/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.tips;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessor;
import org.eclipse.recommenders.internal.completion.rcp.DiscoveryCompletionProposal;
import org.eclipse.recommenders.rcp.SharedImages;
import org.osgi.service.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TipsSessionProcessor
extends SessionProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(TipsSessionProcessor.class);
    private static final String PREF_NODE_ID_TIPS = "org.eclipse.recommenders.completion.rcp.tips";
    private static final String SEEN = "seen";
    private final List<ICompletionProposal> unseenTips = Lists.newLinkedList();
    private final HashSet<String> seenTips;
    private boolean tipsSeen;

    @Inject
    public TipsSessionProcessor(SharedImages images) {
        ImmutableList availableTips = ImmutableList.of((Object)((Object)new DiscoveryCompletionProposal(images)));
        Iterable split = Splitter.on((String)":").omitEmptyStrings().split((CharSequence)TipsSessionProcessor.getTipsPreferences().get(SEEN, ""));
        this.seenTips = Sets.newHashSet((Iterable)split);
        for (ICompletionProposal availableTip : availableTips) {
            if (this.seenTips.contains(availableTip.getClass().getName())) continue;
            this.unseenTips.add(availableTip);
        }
    }

    @Override
    public boolean startSession(IRecommendersCompletionContext context) {
        if (this.preventsAutoComplete(context)) {
            return false;
        }
        return !this.unseenTips.isEmpty();
    }

    private boolean preventsAutoComplete(IRecommendersCompletionContext context) {
        return context.getProposals().size() <= 1;
    }

    @Override
    public void endSession(List<ICompletionProposal> proposals) {
        proposals.addAll(this.unseenTips);
        this.tipsSeen = false;
    }

    @Override
    public void selected(ICompletionProposal proposal) {
        if (this.unseenTips.remove(proposal)) {
            this.seenTips.add(proposal.getClass().getName());
            this.tipsSeen = true;
        }
    }

    @Override
    public void aboutToClose() {
        if (this.tipsSeen) {
            TipsSessionProcessor.persistSeenTips(this.seenTips);
        }
    }

    private static void persistSeenTips(Set<String> seenTips) {
        String joined = Joiner.on((char)':').join(seenTips);
        IEclipsePreferences store = TipsSessionProcessor.getTipsPreferences();
        store.put(SEEN, joined);
        try {
            store.flush();
        }
        catch (BackingStoreException e) {
            LOG.error("Failed to flush preferences", (Throwable)e);
        }
    }

    private static IEclipsePreferences getTipsPreferences() {
        return InstanceScope.INSTANCE.getNode(PREF_NODE_ID_TIPS);
    }
}

