/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.injection;

import com.google.common.collect.Lists;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectionDescriptor {
    private static final Logger LOG = LoggerFactory.getLogger(InjectionDescriptor.class);
    private static final String ATTR_CLASS = "class";
    private static final String EXT_POINT_ID = "org.eclipse.recommenders.injection.modules";
    private final IConfigurationElement element;

    public static List<InjectionDescriptor> getDescriptors() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extpoint = registry.getExtensionPoint(EXT_POINT_ID);
        ArrayList descriptors = Lists.newArrayList();
        IExtension[] iExtensionArray = extpoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement config = iConfigurationElementArray[n4];
                InjectionDescriptor desc = new InjectionDescriptor(config);
                descriptors.add(desc);
                ++n4;
            }
            ++n2;
        }
        return descriptors;
    }

    public static List<Module> createModules() {
        ArrayList engines = Lists.newArrayList();
        for (InjectionDescriptor desc : InjectionDescriptor.getDescriptors()) {
            try {
                engines.add(desc.createInstance());
            }
            catch (CoreException e) {
                LOG.error("Failed to create module from " + desc.getPluginId(), (Throwable)e);
            }
        }
        return engines;
    }

    protected InjectionDescriptor(IConfigurationElement element) {
        this.element = element;
    }

    public String getPluginId() {
        String pluginId = this.element.getContributor().getName();
        return pluginId;
    }

    public Module createInstance() throws CoreException {
        return (Module)this.element.createExecutableExtension(ATTR_CLASS);
    }
}

