/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.recommenders.models.DependencyInfo;
import org.eclipse.recommenders.models.DependencyType;

public final class Dependencies {
    @Inject
    @VisibleForTesting
    public static IWorkspaceRoot workspace;

    public static Optional<DependencyInfo> createJREDependencyInfo(IJavaProject javaProject) {
        Optional<String> executionEnvironmentId = Dependencies.getExecutionEnvironmentId(javaProject);
        try {
            IVMInstall vmInstall = JavaRuntime.getVMInstall((IJavaProject)javaProject);
            if (vmInstall == null) {
                return Optional.absent();
            }
            File javaHome = vmInstall.getInstallLocation();
            HashMap hints = Maps.newHashMap();
            if (executionEnvironmentId.isPresent()) {
                hints.put("EXECUTION_ENVIRONMENT", (String)executionEnvironmentId.get());
            }
            return Optional.of((Object)new DependencyInfo(javaHome, DependencyType.JRE, (Map)hints));
        }
        catch (CoreException coreException) {
            return Optional.absent();
        }
    }

    private static Optional<String> getExecutionEnvironmentId(IJavaProject javaProject) {
        try {
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 5) {
                    return Optional.fromNullable((Object)JavaRuntime.getExecutionEnvironmentId((IPath)entry.getPath()));
                }
                ++n2;
            }
            return Optional.absent();
        }
        catch (JavaModelException javaModelException) {
            return Optional.absent();
        }
    }

    public static DependencyInfo createDependencyInfoForProject(IJavaProject project) {
        File file = workspace.findMember(project.getPath()).getLocation().toFile();
        HashMap hints = Maps.newHashMap();
        hints.put("PROJECT_NAME", project.getElementName());
        DependencyInfo dependencyInfo = new DependencyInfo(file, DependencyType.PROJECT, (Map)hints);
        return dependencyInfo;
    }
}

