/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import java.io.File;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.recommenders.internal.models.rcp.Messages;
import org.eclipse.recommenders.models.DownloadCallback;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.ModelCoordinate;
import org.eclipse.recommenders.models.rcp.ModelEvents;
import org.eclipse.recommenders.rcp.utils.Logs;
import org.eclipse.ui.statushandlers.StatusManager;

public class DownloadModelArchiveJob
extends Job {
    private final Map<String, IProgressMonitor> downloads = Maps.newHashMap();
    private final IModelRepository repository;
    private final ModelCoordinate mc;
    private final boolean forceDownload;
    private final EventBus bus;

    public DownloadModelArchiveJob(IModelRepository repository, ModelCoordinate mc, boolean forceDownload, EventBus bus) {
        super(MessageFormat.format(Messages.JOB_RESOLVING_MODEL, mc));
        this.repository = repository;
        this.mc = mc;
        this.forceDownload = forceDownload;
        this.bus = bus;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask(MessageFormat.format(Messages.TASK_RESOLVING_MODEL, this.mc), -1);
            ModelArchiveDownloadCallback cb = new ModelArchiveDownloadCallback(monitor);
            File result = (File)this.repository.resolve(this.mc, this.forceDownload, (DownloadCallback)cb).orNull();
            if (cb.downloadedArchive) {
                this.bus.post((Object)new ModelEvents.ModelArchiveDownloadedEvent(this.mc));
            }
            if (result == null) {
                IStatus err = Logs.newStatus((int)1, null, (String)"org.eclipse.recommenders.models.rcp", (String)Messages.LOG_INFO_NO_MODEL_RESOLVED, (Object[])new Object[]{this.mc, this.repository});
                StatusManager.getManager().handle(err, 1);
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
        }
        catch (Exception e) {
            IStatus iStatus = Logs.newStatus((int)4, (Throwable)e, (String)"org.eclipse.recommenders.models.rcp", (String)Messages.LOG_ERROR_MODEL_RESOLUTION_FAILURE, (Object[])new Object[]{this.mc});
            return iStatus;
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private final class ModelArchiveDownloadCallback
    extends DownloadCallback {
        private final IProgressMonitor monitor;
        private boolean downloadedArchive;

        private ModelArchiveDownloadCallback(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public synchronized void downloadInitiated(String path) {
            DownloadModelArchiveJob.this.downloads.put(path, new SubProgressMonitor(this.monitor, 1));
        }

        public synchronized void downloadProgressed(String path, long transferred, long total) {
            IProgressMonitor submonitor = (IProgressMonitor)DownloadModelArchiveJob.this.downloads.get(path);
            String message = String.valueOf(this.bytesToString(transferred)) + "/" + this.bytesToString(total);
            submonitor.subTask(message);
            submonitor.worked(1);
        }

        public synchronized void downloadSucceeded(String path) {
            ((IProgressMonitor)DownloadModelArchiveJob.this.downloads.get(path)).done();
            this.downloadedArchive = true;
        }

        public synchronized void downloadFailed(String path) {
            ((IProgressMonitor)DownloadModelArchiveJob.this.downloads.get(path)).done();
        }

        private String bytesToString(long bytes) {
            if (bytes < 1024L) {
                return String.valueOf(bytes) + " B";
            }
            int exp = (int)(Math.log(bytes) / Math.log(1024.0));
            String pre = String.valueOf("KMGTPE".charAt(exp - 1)) + "i";
            return String.format("%.1f %sB", (double)bytes / Math.pow(1024.0, exp), pre);
        }
    }
}

