/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.io.Files;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.recommenders.internal.models.rcp.AdvisorDescriptor;
import org.eclipse.recommenders.internal.models.rcp.AdvisorDescriptors;
import org.eclipse.recommenders.internal.models.rcp.DependencyInfoJsonTypeAdapter;
import org.eclipse.recommenders.internal.models.rcp.Messages;
import org.eclipse.recommenders.internal.models.rcp.ModelsRcpPreferences;
import org.eclipse.recommenders.internal.models.rcp.OptionalJsonTypeAdapter;
import org.eclipse.recommenders.internal.models.rcp.ProjectCoordinateJsonTypeAdapter;
import org.eclipse.recommenders.models.DependencyInfo;
import org.eclipse.recommenders.models.IProjectCoordinateAdvisor;
import org.eclipse.recommenders.models.IProjectCoordinateAdvisorService;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.models.advisors.ProjectCoordinateAdvisorService;
import org.eclipse.recommenders.models.rcp.ModelEvents;
import org.eclipse.recommenders.rcp.IRcpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EclipseProjectCoordinateAdvisorService
implements IProjectCoordinateAdvisorService,
IRcpService {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final ProjectCoordinateAdvisorService delgate;
    private final ModelsRcpPreferences prefs;
    private final LoadingCache<DependencyInfo, Optional<ProjectCoordinate>> projectCoordianteCache;
    private final File persistenceFile;
    private final Gson cacheGson;
    private final Type cacheType = new TypeToken<Map<DependencyInfo, Optional<ProjectCoordinate>>>(){}.getType();
    private Map<IProjectCoordinateAdvisor, AdvisorDescriptor> descriptors = Maps.newHashMap();

    @Inject
    public EclipseProjectCoordinateAdvisorService(@Named(value="IDENTIFIED_PACKAGE_FRAGMENT_ROOTS") File persistenceFile, EventBus bus, ModelsRcpPreferences prefs) {
        bus.register((Object)this);
        this.prefs = prefs;
        this.delgate = new ProjectCoordinateAdvisorService();
        this.persistenceFile = persistenceFile;
        this.cacheGson = new GsonBuilder().registerTypeAdapter(ProjectCoordinate.class, (Object)new ProjectCoordinateJsonTypeAdapter()).registerTypeAdapter(DependencyInfo.class, (Object)new DependencyInfoJsonTypeAdapter()).registerTypeAdapter(Optional.class, new OptionalJsonTypeAdapter()).enableComplexMapKeySerialization().serializeNulls().create();
        this.projectCoordianteCache = this.createCache();
        this.configureAdvisorList(prefs.advisorConfiguration);
    }

    private LoadingCache<DependencyInfo, Optional<ProjectCoordinate>> createCache() {
        return CacheBuilder.newBuilder().maximumSize(200L).build((CacheLoader)new CacheLoader<DependencyInfo, Optional<ProjectCoordinate>>(){

            public Optional<ProjectCoordinate> load(DependencyInfo info) {
                return EclipseProjectCoordinateAdvisorService.this.delgate.suggest(info);
            }
        });
    }

    private void configureAdvisorList(String advisorConfiguration) {
        this.setAdvisors(this.provideAdvisors(advisorConfiguration));
    }

    private List<IProjectCoordinateAdvisor> provideAdvisors(String advisorConfiguration) {
        HashMap newDescriptors = Maps.newHashMap();
        List<AdvisorDescriptor> registeredAdvisors = AdvisorDescriptors.getRegisteredAdvisors();
        List<AdvisorDescriptor> loadedDescriptors = AdvisorDescriptors.load(advisorConfiguration, registeredAdvisors);
        ArrayList advisors = Lists.newArrayListWithCapacity((int)loadedDescriptors.size());
        for (AdvisorDescriptor descriptor : loadedDescriptors) {
            try {
                if (!descriptor.isEnabled()) continue;
                IProjectCoordinateAdvisor advisor = descriptor.createAdvisor();
                advisors.add(advisor);
                newDescriptors.put(advisor, descriptor);
            }
            catch (CoreException e) {
                this.LOG.error("Exception during creation of advisor {}.", (Object)descriptor.getId(), (Object)e);
            }
        }
        this.descriptors = newDescriptors;
        return advisors;
    }

    public AdvisorDescriptor getDescriptor(IProjectCoordinateAdvisor advisor) {
        return this.descriptors.get(advisor);
    }

    public Optional<ProjectCoordinate> suggest(DependencyInfo dependencyInfo) {
        try {
            return (Optional)this.projectCoordianteCache.get((Object)dependencyInfo);
        }
        catch (ExecutionException e) {
            this.LOG.error("Exception occured while accessing project coordinates cache.", (Throwable)e);
            return Optional.absent();
        }
    }

    public ImmutableList<IProjectCoordinateAdvisor> getAdvisors() {
        return this.delgate.getAdvisors();
    }

    public void addAdvisor(IProjectCoordinateAdvisor advisor) {
        this.delgate.addAdvisor(advisor);
    }

    public void setAdvisors(List<IProjectCoordinateAdvisor> advisors) {
        this.delgate.setAdvisors(advisors);
    }

    @PostConstruct
    public void open() throws IOException {
        if (!this.persistenceFile.exists()) {
            return;
        }
        String json = Files.toString((File)this.persistenceFile, (Charset)Charsets.UTF_8);
        Map deserializedCache = (Map)this.cacheGson.fromJson(json, this.cacheType);
        for (Map.Entry entry : deserializedCache.entrySet()) {
            this.projectCoordianteCache.put((Object)((DependencyInfo)entry.getKey()), (Object)((Optional)entry.getValue()));
        }
    }

    @PreDestroy
    public void close() throws IOException {
        String json = this.cacheGson.toJson((Object)this.projectCoordianteCache.asMap(), this.cacheType);
        Files.write((CharSequence)json, (File)this.persistenceFile, (Charset)Charsets.UTF_8);
    }

    @Subscribe
    public void onEvent(ModelEvents.ProjectCoordinateChangeEvent e) {
        this.projectCoordianteCache.invalidate((Object)e.dependencyInfo);
    }

    @Subscribe
    public void onEvent(ModelEvents.AdvisorConfigurationChangedEvent e) throws IOException {
        this.projectCoordianteCache.invalidateAll();
        this.configureAdvisorList(this.prefs.advisorConfiguration);
    }

    @Subscribe
    public void onEvent(ModelEvents.ModelIndexOpenedEvent e) {
        new RefreshProjectCoordinatesJob(Messages.JOB_REFRESHING_CACHED_COORDINATES).schedule();
    }

    public void clearCache() {
        this.projectCoordianteCache.invalidateAll();
    }

    private final class RefreshProjectCoordinatesJob
    extends Job {
        private RefreshProjectCoordinatesJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            Set dependencyInfos = EclipseProjectCoordinateAdvisorService.this.projectCoordianteCache.asMap().keySet();
            try {
                monitor.beginTask(Messages.TASK_REFRESHING, dependencyInfos.size());
                for (DependencyInfo di : dependencyInfos) {
                    monitor.subTask(di.toString());
                    EclipseProjectCoordinateAdvisorService.this.projectCoordianteCache.refresh((Object)di);
                    monitor.worked(1);
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }
}

