/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.name.Named;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.recommenders.internal.models.rcp.Dialogs;
import org.eclipse.recommenders.internal.models.rcp.EclipseModelRepository;
import org.eclipse.recommenders.internal.models.rcp.KnownCoordinatePatternFilter;
import org.eclipse.recommenders.internal.models.rcp.Messages;
import org.eclipse.recommenders.internal.models.rcp.ModelsRcpPreferences;
import org.eclipse.recommenders.models.Coordinates;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.ModelCoordinate;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.models.rcp.ModelEvents;
import org.eclipse.recommenders.models.rcp.actions.TriggerModelDownloadForModelCoordinatesAction;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.rcp.utils.Selections;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.osgi.service.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelRepositoriesView
extends ViewPart {
    private static final Logger LOG = LoggerFactory.getLogger(ModelRepositoriesView.class);
    private DataBindingContext bindingContext;
    private Tree tree;
    private Action addRemoteRepositoryAction;
    private final IModelIndex index;
    private final SharedImages images;
    private final EclipseModelRepository repo;
    private final ModelsRcpPreferences prefs;
    private final List<String> modelClassifiers;
    private final EventBus bus;
    private TreeViewer treeViewer;
    private List<KnownCoordinate> values = Lists.newArrayList();
    private Text txtSearch;
    final PatternFilter patternFilter = new PatternFilter(){

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            if (element instanceof KnownCoordinate) {
                KnownCoordinate coor = (KnownCoordinate)element;
                return this.wordMatches(coor.pc.toString());
            }
            if (element instanceof String) {
                return true;
            }
            return super.isLeafMatch(viewer, element);
        }
    };

    @Inject
    public ModelRepositoriesView(IModelIndex index, SharedImages images, EclipseModelRepository repo, ModelsRcpPreferences prefs, @Named(value="MODEL_CLASSIFIER") ImmutableSet<String> modelClassifiers, EventBus bus) {
        this.index = index;
        this.images = images;
        this.repo = repo;
        this.prefs = prefs;
        this.modelClassifiers = Lists.newArrayList(modelClassifiers);
        Collections.sort(this.modelClassifiers);
        this.bus = bus;
    }

    public void createPartControl(Composite parent) {
        this.bus.register((Object)this);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.txtSearch = new Text(container, 2944);
        this.txtSearch.setMessage(Messages.SEARCH_PLACEHOLDER_FILTER_TEXT);
        this.txtSearch.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002 && ModelRepositoriesView.this.tree.getItemCount() != 0) {
                    ModelRepositoriesView.this.tree.setFocus();
                    ModelRepositoriesView.this.tree.setSelection(ModelRepositoriesView.this.tree.getTopItem());
                }
            }
        });
        Composite composite = new Composite(container, 0);
        TreeColumnLayout treeLayout = new TreeColumnLayout();
        composite.setLayout((Layout)treeLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.treeViewer = new TreeViewer(composite, 67584);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        this.tree = this.treeViewer.getTree();
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        TreeViewerColumn repositoryViewerColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn repositoryColumn = repositoryViewerColumn.getColumn();
        treeLayout.setColumnData((Widget)repositoryColumn, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        repositoryColumn.setText(Messages.COLUMN_LABEL_REPOSITORY);
        repositoryViewerColumn.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                StyledString text = new StyledString();
                if (element instanceof String) {
                    String url = (String)element;
                    text.append(url);
                    text.append(" ");
                    text.append(MessageFormat.format(Messages.TABLE_CELL_SUFFIX_KNOWN_COORDINATES, ModelRepositoriesView.this.fetchNumberOfModels(url)), StyledString.COUNTER_STYLER);
                    cell.setImage(ModelRepositoriesView.this.images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_REPOSITORY));
                }
                if (element instanceof KnownCoordinate) {
                    KnownCoordinate v = (KnownCoordinate)element;
                    text.append(v.pc.toString());
                }
                cell.setText(text.toString());
                cell.setStyleRanges(text.getStyleRanges());
                super.update(cell);
            }
        });
        int minWidth = this.calculateMinColumnWidthForClassifier();
        for (String classifier : this.modelClassifiers) {
            this.newColumn(treeLayout, classifier, minWidth);
        }
        this.treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return element instanceof String;
            }

            public Object getParent(Object element) {
                if (element instanceof KnownCoordinate) {
                    KnownCoordinate v = (KnownCoordinate)element;
                    return v.url;
                }
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return ((ModelRepositoriesView)ModelRepositoriesView.this).prefs.remotes;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof String) {
                    String url = (String)parentElement;
                    ImmutableListMultimap multimap = ModelRepositoriesView.this.groupByUrl(ModelRepositoriesView.this.values);
                    return multimap.get((Object)url).toArray();
                }
                return new Object[0];
            }
        });
        this.treeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof String && e2 instanceof String) {
                    String s1 = (String)e1;
                    String s2 = (String)e2;
                    return this.position(s1).compareTo(this.position(s2));
                }
                if (e1 instanceof KnownCoordinate && e2 instanceof KnownCoordinate) {
                    KnownCoordinate v1 = (KnownCoordinate)e1;
                    KnownCoordinate v2 = (KnownCoordinate)e2;
                    return v1.pc.toString().compareTo(v2.pc.toString());
                }
                return super.compare(viewer, e1, e2);
            }

            public Integer position(String string) {
                String[] remotes = ((ModelRepositoriesView)ModelRepositoriesView.this).prefs.remotes;
                int i = 0;
                while (i < remotes.length) {
                    if (remotes[i].equals(string)) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }
        });
        this.initializeContent();
        this.addRemoteRepositoryAction = new Action(){

            public void run() {
                ModelRepositoriesView.this.addRemoteRepository();
            }
        };
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.addAction(Messages.TOOLBAR_TOOLTIP_ADD_REPOSITORY, (SharedImages.ImageResource)SharedImages.Images.ELCL_ADD_REPOSITORY, (IContributionManager)toolBarManager, (IAction)this.addRemoteRepositoryAction);
        this.addAction(Messages.TOOLBAR_TOOLTIP_REFRESH, (SharedImages.ImageResource)SharedImages.Images.ELCL_REFRESH, (IContributionManager)toolBarManager, (IAction)new Action(){

            public void run() {
                ModelRepositoriesView.this.refreshData();
            }
        });
        this.addAction(Messages.TOOLBAR_TOOLTIP_EXPAND_ALL, (SharedImages.ImageResource)SharedImages.Images.ELCL_EXPAND_ALL, (IContributionManager)toolBarManager, (IAction)new Action(){

            public void run() {
                ModelRepositoriesView.this.treeViewer.expandAll();
            }
        });
        this.addAction(Messages.TOOLBAR_TOOLTIP_COLLAPSE_ALL, (SharedImages.ImageResource)SharedImages.Images.ELCL_COLLAPSE_ALL, (IContributionManager)toolBarManager, (IAction)new Action(){

            public void run() {
                ModelRepositoriesView.this.treeViewer.collapseAll();
            }
        });
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        this.addAction(Messages.MENUITEM_DELETE_MODELS, (SharedImages.ImageResource)SharedImages.Images.ELCL_DELETE, (IContributionManager)menuManager, (IAction)new Action(){

            public void run() {
                ModelRepositoriesView.this.deleteCacheAndRefresh();
            }
        });
        this.addContextMenu();
        this.bindingContext = this.initDataBindings();
    }

    private int calculateMinColumnWidthForClassifier() {
        GC gc = new GC((Drawable)this.tree);
        int maxLength = 0;
        for (String classifier : this.modelClassifiers) {
            int extent = gc.textExtent((String)classifier).x;
            if (extent <= maxLength) continue;
            maxLength = extent;
        }
        gc.dispose();
        return maxLength;
    }

    private ImmutableListMultimap<String, KnownCoordinate> groupByUrl(List<KnownCoordinate> values) {
        return Multimaps.index(values, (Function)new Function<KnownCoordinate, String>(){

            public String apply(KnownCoordinate arg0) {
                return arg0.url;
            }
        });
    }

    protected int fetchNumberOfModels(String url) {
        return this.groupByUrl(this.values).get((Object)url).size();
    }

    private void addAction(String text, SharedImages.ImageResource imageResource, IContributionManager contributionManager, IAction action) {
        action.setImageDescriptor(this.images.getDescriptor(imageResource));
        action.setText(text);
        action.setToolTipText(text);
        contributionManager.add(action);
    }

    private void addContextMenu() {
        final MenuManager menuManager = new MenuManager();
        Menu contextMenu = menuManager.createContextMenu((Control)this.tree);
        menuManager.setRemoveAllWhenShown(true);
        this.tree.setMenu(contextMenu);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (this.isValidType(ModelRepositoriesView.this.treeViewer.getSelection(), KnownCoordinate.class)) {
                    Set selectedValues = Selections.toSet((ISelection)ModelRepositoriesView.this.treeViewer.getSelection());
                    HashSet selectedModelCoordinates = Sets.newHashSet();
                    for (KnownCoordinate value : selectedValues) {
                        Collection<ModelCoordinate> mcs = value.mcs;
                        selectedModelCoordinates.addAll(mcs);
                    }
                    if (!selectedValues.isEmpty()) {
                        TriggerModelDownloadForModelCoordinatesAction action = new TriggerModelDownloadForModelCoordinatesAction(Messages.MENUITEM_DOWNLOAD_MODELS, selectedModelCoordinates, ModelRepositoriesView.this.repo, ModelRepositoriesView.this.bus);
                        menuManager.add((IAction)action);
                    }
                }
                if (this.isValidType(ModelRepositoriesView.this.treeViewer.getSelection(), String.class)) {
                    ModelRepositoriesView.this.addAction(Messages.MENUITEM_ADD_REPOSITORY, (SharedImages.ImageResource)SharedImages.Images.ELCL_ADD_REPOSITORY, (IContributionManager)menuManager, (IAction)ModelRepositoriesView.this.addRemoteRepositoryAction);
                    final Optional url = Selections.getFirstSelected((ISelection)ModelRepositoriesView.this.treeViewer.getSelection());
                    if (url.isPresent() && ((ModelRepositoriesView)ModelRepositoriesView.this).prefs.remotes.length > 1) {
                        ModelRepositoriesView.this.addAction(Messages.MENUITEM_REMOVE_REPOSITORY, (SharedImages.ImageResource)SharedImages.Images.ELCL_REMOVE_REPOSITORY, (IContributionManager)menuManager, (IAction)new Action(){

                            public void run() {
                                ModelRepositoriesView.this.deleteRepository((String)url.get());
                                ModelRepositoriesView.this.refreshData();
                            }
                        });
                    }
                }
            }

            private boolean isValidType(ISelection selection, Class<?> expectedType) {
                return Selections.safeFirstElement((ISelection)ModelRepositoriesView.this.treeViewer.getSelection(), expectedType).isPresent();
            }
        });
    }

    private void newColumn(TreeColumnLayout treeLayout, final String classifier, int minWidth) {
        TreeViewerColumn classifierViewerColumn = new TreeViewerColumn(this.treeViewer, 0x1000000);
        TreeColumn classifierColumn = classifierViewerColumn.getColumn();
        classifierColumn.setMoveable(true);
        classifierColumn.setResizable(false);
        treeLayout.setColumnData((Widget)classifierColumn, (ColumnLayoutData)new ColumnPixelData(minWidth, false, true));
        classifierColumn.setText(classifier.toUpperCase());
        classifierViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }

            public String getToolTipText(Object element) {
                if (element instanceof KnownCoordinate) {
                    KnownCoordinate v = (KnownCoordinate)element;
                    if (!v.hasModelCoordinate(classifier)) {
                        return Messages.TABLE_CELL_TOOLTIP_UNAVAILABLE;
                    }
                    if (v.isDownloaded(classifier)) {
                        return Messages.TABLE_CELL_TOOLTIP_AVAILABLE_LOCALLY;
                    }
                    return Messages.TABLE_CELL_TOOLTIP_AVAILABLE_REMOTELY;
                }
                return null;
            }

            public Image getImage(Object element) {
                if (element instanceof KnownCoordinate) {
                    KnownCoordinate v = (KnownCoordinate)element;
                    if (!v.hasModelCoordinate(classifier)) {
                        return ModelRepositoriesView.this.images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_CROSS_RED);
                    }
                    if (v.isDownloaded(classifier)) {
                        return ModelRepositoriesView.this.images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_CHECK_GREEN);
                    }
                    return ModelRepositoriesView.this.images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_BULLET_BLUE);
                }
                return null;
            }
        });
    }

    private void initializeContent() {
        Multimap<String, ModelCoordinate> groupedByRepository = this.fetchDataGroupedByRepository();
        this.values = Lists.newArrayList();
        for (Map.Entry entry : groupedByRepository.asMap().entrySet()) {
            this.values.addAll(this.createValues((String)entry.getKey(), (Collection)entry.getValue()));
        }
        this.treeViewer.setInput(this.values);
    }

    private List<KnownCoordinate> createValues(String url, Collection<ModelCoordinate> collection) {
        Multimap<ProjectCoordinate, ModelCoordinate> map = this.groupDataByProjectCoordinate(collection);
        ArrayList values = Lists.newArrayList();
        for (ProjectCoordinate rep : map.keySet()) {
            values.add(new KnownCoordinate(url, rep, map.get((Object)rep)));
        }
        return values;
    }

    private Multimap<String, ModelCoordinate> fetchDataGroupedByRepository() {
        LinkedListMultimap temp = LinkedListMultimap.create();
        for (String classifier : this.modelClassifiers) {
            this.addModelCoordinateToIndex((Multimap<String, ModelCoordinate>)temp, classifier);
        }
        return temp;
    }

    private void addModelCoordinateToIndex(Multimap<String, ModelCoordinate> temp, String classifier) {
        for (ModelCoordinate mc : this.index.getKnownModels(classifier)) {
            Optional hint = mc.getHint("repository.url");
            if (!hint.isPresent()) continue;
            temp.put((Object)((String)hint.get()), (Object)mc);
        }
    }

    private Multimap<ProjectCoordinate, ModelCoordinate> groupDataByProjectCoordinate(Collection<ModelCoordinate> collection) {
        LinkedListMultimap map = LinkedListMultimap.create();
        for (ModelCoordinate modelCoordinate : collection) {
            map.put((Object)Coordinates.toProjectCoordinate((ModelCoordinate)modelCoordinate), (Object)modelCoordinate);
        }
        return map;
    }

    public void setFocus() {
        this.tree.setFocus();
    }

    public void setFilter(String filter) {
        this.treeViewer.getTree().setRedraw(false);
        KnownCoordinatePatternFilter patternFilter = new KnownCoordinatePatternFilter();
        patternFilter.setPattern("*" + filter);
        this.treeViewer.setFilters(new ViewerFilter[]{patternFilter});
        this.treeViewer.getTree().setRedraw(true);
        this.treeViewer.expandAll();
    }

    public void dispose() {
        super.dispose();
        this.bindingContext.dispose();
        this.bus.unregister((Object)this);
    }

    @Subscribe
    public void onModelIndexOpened(ModelEvents.ModelIndexOpenedEvent e) {
        this.refreshData();
    }

    @Subscribe
    public void onAdvisorConfigurationChanged(ModelEvents.AdvisorConfigurationChangedEvent e) throws IOException {
        this.refreshData();
    }

    @Subscribe
    public void onModelArchiveDownloaded(final ModelEvents.ModelArchiveDownloadedEvent e) {
        new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                KnownCoordinate key = this.createKey(e.model);
                KnownCoordinate element = (KnownCoordinate)Iterables.tryFind((Iterable)ModelRepositoriesView.this.values, (Predicate)Predicates.equalTo((Object)key)).orNull();
                if (element != null) {
                    ModelRepositoriesView.this.treeViewer.update((Object)element, null);
                }
                return Status.OK_STATUS;
            }

            private KnownCoordinate createKey(ModelCoordinate mc) {
                Optional remoteUrl = mc.getHint("repository.url");
                if (remoteUrl.isPresent()) {
                    return new KnownCoordinate((String)remoteUrl.get(), Coordinates.toProjectCoordinate((ModelCoordinate)mc), Collections.<ModelCoordinate>emptyList());
                }
                return null;
            }
        }.schedule();
    }

    private void refreshData() {
        new UIJob(Messages.JOB_REFRESHING_MODEL_REPOSITORIES_VIEW){
            {
                this.schedule();
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ModelRepositoriesView.this.initializeContent();
                return Status.OK_STATUS;
            }
        };
    }

    private void addRemoteRepository() {
        InputDialog inputDialog = Dialogs.newModelRepositoryUrlDialog(this.tree.getShell(), this.prefs.remotes);
        if (inputDialog.open() == 0) {
            this.addRepository(inputDialog.getValue());
        }
    }

    private void deleteRepository(String remoteUrl) {
        ArrayList newRemotes = Lists.newArrayList((Object[])this.prefs.remotes);
        newRemotes.remove(remoteUrl);
        this.storeRepositories(newRemotes);
    }

    private void addRepository(String remoteUrl) {
        ArrayList newRemotes = Lists.newArrayList((Object[])this.prefs.remotes);
        newRemotes.add(remoteUrl);
        this.storeRepositories(newRemotes);
    }

    private void storeRepositories(ArrayList<String> newRemotes) {
        try {
            IEclipsePreferences s = InstanceScope.INSTANCE.getNode("org.eclipse.recommenders.models.rcp");
            s.put("repository.url.list", ModelsRcpPreferences.joinRemoteRepositoriesToString(newRemotes));
            s.flush();
        }
        catch (BackingStoreException e) {
            LOG.error("Exception during storing of remote repository preferences", (Throwable)e);
        }
    }

    private void deleteCacheAndRefresh() {
        new Job(Messages.JOB_DELETING_MODEL_CACHE){
            {
                this.schedule();
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ModelRepositoriesView.this.repo.deleteModels();
                    ModelRepositoriesView.this.refreshData();
                    return Status.OK_STATUS;
                }
                catch (IOException iOException) {
                    return new Status(4, "org.eclipse.recommenders.models.rcp", Messages.LOG_ERROR_FAILED_TO_DELETE_MODEL_CACHE);
                }
            }
        };
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue search = WidgetProperties.text((int)24).observeDelayed(400, (Widget)this.txtSearch);
        IObservableValue filter = PojoProperties.value((String)"filter").observe((Object)this);
        bindingContext.bindValue(filter, (IObservableValue)search, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        return bindingContext;
    }

    public class KnownCoordinate {
        public String url;
        public ProjectCoordinate pc;
        public Collection<ModelCoordinate> mcs;

        public KnownCoordinate(String url, ProjectCoordinate pc, Collection<ModelCoordinate> mcs) {
            this.url = url;
            this.pc = pc;
            this.mcs = mcs;
        }

        private Optional<ModelCoordinate> searchModelCoordinate(String classifier) {
            for (ModelCoordinate mc : this.mcs) {
                if (!mc.getClassifier().equals(classifier)) continue;
                return Optional.of((Object)mc);
            }
            return Optional.absent();
        }

        public boolean isDownloaded(String classifier) {
            Optional<ModelCoordinate> omc = this.searchModelCoordinate(classifier);
            if (omc.isPresent()) {
                return ModelRepositoriesView.this.repo.getLocation((ModelCoordinate)omc.get(), false).isPresent();
            }
            return false;
        }

        public boolean hasModelCoordinate(String classifier) {
            return this.searchModelCoordinate(classifier).isPresent();
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[]{"mcs"});
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[]{"mcs"});
        }
    }
}

