/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.eventbus.EventBus;
import javax.inject.Inject;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.recommenders.models.rcp.ModelEvents;

public class ModelsRcpPreferences {
    @Inject
    @Preference(value="repository.auto.download")
    public boolean autoDownloadEnabled;
    public String[] remotes;
    public String advisorConfiguration;
    private final EventBus bus;
    static final String URL_SEPARATOR = "\t";

    @Inject
    public ModelsRcpPreferences(EventBus bus) {
        this.bus = bus;
    }

    @Inject
    public void setRemote(@Preference(value="repository.url.list") String newRemote) throws Exception {
        String[] old = this.remotes;
        this.remotes = ModelsRcpPreferences.splitRemoteRepositoryString(newRemote);
        if (!ArrayUtils.isEquals((Object)this.remotes, (Object)old)) {
            this.bus.post((Object)new ModelEvents.ModelRepositoryUrlChangedEvent());
        }
    }

    @Inject
    public void setAdvisorConfiguration(@Preference(value="advisor.list.sorted") String newAdvisorConfiguration) throws Exception {
        String old = this.advisorConfiguration;
        this.advisorConfiguration = newAdvisorConfiguration;
        if (!ArrayUtils.isEquals((Object)this.advisorConfiguration, (Object)old)) {
            this.bus.post((Object)new ModelEvents.AdvisorConfigurationChangedEvent());
        }
    }

    public static String[] splitRemoteRepositoryString(String remoteUrls) {
        Iterable split = Splitter.on((String)URL_SEPARATOR).omitEmptyStrings().split((CharSequence)remoteUrls);
        return (String[])Iterables.toArray((Iterable)split, String.class);
    }

    public static String joinRemoteRepositoriesToString(String[] remotes) {
        return Joiner.on((String)URL_SEPARATOR).join((Object[])remotes);
    }

    public static String joinRemoteRepositoriesToString(Iterable<String> remotes) {
        return ModelsRcpPreferences.joinRemoteRepositoriesToString((String[])Iterables.toArray(remotes, String.class));
    }
}

