/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.recommenders.internal.models.rcp.AdvisorDescriptor;
import org.eclipse.recommenders.internal.models.rcp.EclipseDependencyListener;
import org.eclipse.recommenders.internal.models.rcp.EclipseProjectCoordinateAdvisorService;
import org.eclipse.recommenders.internal.models.rcp.ManualProjectCoordinateAdvisor;
import org.eclipse.recommenders.internal.models.rcp.Messages;
import org.eclipse.recommenders.models.DependencyInfo;
import org.eclipse.recommenders.models.IProjectCoordinateAdvisor;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.models.rcp.ModelEvents;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.rcp.utils.TableSortConfigurator;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class ProjectCoordinatesView
extends ViewPart {
    private static final int COLUMN_LOCATION = 0;
    private static final int COLUMN_COORDINATE = 1;
    private TableViewer tableViewer;
    private ContentProvider contentProvider;
    private final EclipseDependencyListener dependencyListener;
    private final EclipseProjectCoordinateAdvisorService pcAdvisorsService;
    private final ManualProjectCoordinateAdvisor manualPcAdvisor;
    private Table table;
    private TableViewerColumn locationColumn;
    private TableViewerColumn coordinateColumn;
    private final EventBus bus;
    private final SharedImages images;
    private static final Comparator<Object> COMPARE_COORDINATE = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Map.Entry && o2 instanceof Map.Entry) {
                Map.Entry firstElement = (Map.Entry)Checks.cast((Object)o1);
                Map.Entry secondElement = (Map.Entry)Checks.cast((Object)o2);
                Optional pc1 = ProjectCoordinatesView.findFirstMatchingCoordinate((Collection)firstElement.getValue());
                Optional pc2 = ProjectCoordinatesView.findFirstMatchingCoordinate((Collection)secondElement.getValue());
                if (pc1.isPresent() && pc2.isPresent()) {
                    return ((ProjectCoordinate)pc1.get()).toString().compareTo(((ProjectCoordinate)pc2.get()).toString());
                }
                if (pc1.isPresent() && !pc2.isPresent()) {
                    return -1;
                }
                if (!pc1.isPresent() && pc2.isPresent()) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }
    };
    private static final Comparator<Object> COMPARE_LOCATION = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Map.Entry && o2 instanceof Map.Entry) {
                Map.Entry firstElement = (Map.Entry)Checks.cast((Object)o1);
                Map.Entry secondElement = (Map.Entry)Checks.cast((Object)o2);
                int compareScore = -((DependencyInfo)firstElement.getKey()).getType().compareTo((Enum)((DependencyInfo)secondElement.getKey()).getType());
                if (compareScore == 0) {
                    return ((DependencyInfo)firstElement.getKey()).getFile().getName().compareToIgnoreCase(((DependencyInfo)secondElement.getKey()).getFile().getName());
                }
                return compareScore;
            }
            return 0;
        }
    };

    @Inject
    public ProjectCoordinatesView(EclipseDependencyListener dependencyListener, EclipseProjectCoordinateAdvisorService pcAdvisorService, ManualProjectCoordinateAdvisor manualProjectCoordinateAdvisor, EventBus bus, SharedImages images) {
        this.dependencyListener = dependencyListener;
        this.pcAdvisorsService = pcAdvisorService;
        this.manualPcAdvisor = manualProjectCoordinateAdvisor;
        this.bus = bus;
        bus.register((Object)this);
        this.images = images;
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        TableColumnLayout tableLayout = new TableColumnLayout();
        composite.setLayout((Layout)tableLayout);
        this.tableViewer = new TableViewer(composite, 66306);
        this.contentProvider = new ContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.tableViewer.setInput((Object)this.getViewSite());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
        this.locationColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tableColumn = this.locationColumn.getColumn();
        tableColumn.setText(Messages.COLUMN_LABEL_LOCATION);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        this.coordinateColumn = new TableViewerColumn(this.tableViewer, 0);
        this.coordinateColumn.setEditingSupport((EditingSupport)new ProjectCoordinateEditing(this.tableViewer));
        tableColumn = this.coordinateColumn.getColumn();
        tableColumn.setText(Messages.COLUMN_LABEL_COORDINATE);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        Action refreshAction = new Action(){

            public void run() {
                ProjectCoordinatesView.this.refreshTableUI();
            }
        };
        TableSortConfigurator.newConfigurator((TableViewer)this.tableViewer, (IAction)refreshAction).add(this.locationColumn.getColumn(), COMPARE_LOCATION).add(this.coordinateColumn.getColumn(), COMPARE_COORDINATE).initialize(this.locationColumn.getColumn(), 128).configure();
        this.addFilterFunctionality();
        this.addClearCacheButton();
        this.addRefreshButton();
        this.refreshData();
    }

    private void addFilterFunctionality() {
        ViewerFilter manualAssignedFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof Map.Entry) {
                    Collection value = ProjectCoordinatesView.this.extractProjectCoordinates(element);
                    return this.isManualMapping(value);
                }
                return false;
            }

            private boolean isManualMapping(Collection<Optional<ProjectCoordinate>> pcs) {
                int indexOfManualMapping = ProjectCoordinatesView.this.pcAdvisorsService.getAdvisors().indexOf((Object)ProjectCoordinatesView.this.manualPcAdvisor);
                Optional opc = (Optional)Iterables.get(pcs, (int)indexOfManualMapping);
                return opc.isPresent();
            }
        };
        ViewerFilter conflictingCoordinatesFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof Map.Entry) {
                    Collection value = ProjectCoordinatesView.this.extractProjectCoordinates(element);
                    return Sets.newHashSet((Iterable)Optional.presentInstances((Iterable)value)).size() > 1;
                }
                return false;
            }
        };
        ViewerFilter missingCoordinatesFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof Map.Entry) {
                    Collection value = ProjectCoordinatesView.this.extractProjectCoordinates(element);
                    return Iterables.isEmpty((Iterable)Optional.presentInstances((Iterable)value));
                }
                return true;
            }
        };
        Action showAll = new Action(Messages.MENUITEM_SHOW_ALL, 8){

            public void run() {
                ProjectCoordinatesView.this.refreshTableUI();
            }
        };
        TableFilterAction showMissingCoord = new TableFilterAction(Messages.MENUITEM_SHOW_MISSING_COORDINATES_ONLY, 8, missingCoordinatesFilter);
        TableFilterAction showConflictingCoord = new TableFilterAction(Messages.MENUITEM_SHOW_CONFLICTING_COORDINATES_ONLY, 8, conflictingCoordinatesFilter);
        TableFilterAction showManualAssignedCoord = new TableFilterAction(Messages.MENUITEM_SHOW_MANUALLY_ASSIGNED_COORDINATES_ONLY, 8, manualAssignedFilter);
        MenuManager showMenu = new MenuManager(Messages.MENUITEM_SHOW);
        showMenu.add((IAction)showAll);
        showMenu.add((IAction)showMissingCoord);
        showMenu.add((IAction)showConflictingCoord);
        showMenu.add((IAction)showManualAssignedCoord);
        this.getViewSite().getActionBars().getMenuManager().add((IContributionItem)showMenu);
        showAll.setChecked(true);
    }

    private void addClearCacheButton() {
        Action clearCache = new Action(){

            public void run() {
                ProjectCoordinatesView.this.clearProjectCoordianteCache();
                ProjectCoordinatesView.this.refreshData();
            }
        };
        clearCache.setText(Messages.MENUITEM_CLEAR_CACHE);
        clearCache.setImageDescriptor(this.images.getDescriptor((SharedImages.ImageResource)SharedImages.Images.ELCL_CLEAR));
        this.getViewSite().getActionBars().getMenuManager().add((IAction)clearCache);
    }

    private void clearProjectCoordianteCache() {
        this.pcAdvisorsService.clearCache();
    }

    private void addRefreshButton() {
        Action refreshAction = new Action(){

            public void run() {
                ProjectCoordinatesView.this.refreshData();
            }
        };
        refreshAction.setToolTipText(Messages.TOOLBAR_TOOLTIP_REFRESH);
        refreshAction.setImageDescriptor(this.images.getDescriptor((SharedImages.ImageResource)SharedImages.Images.ELCL_REFRESH));
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)refreshAction);
    }

    private void refreshData() {
        new UIJob(Messages.JOB_REFRESHING_PROJECT_COORDINATES_VIEW){
            {
                this.schedule();
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ProjectCoordinatesView.this.contentProvider.setData((Set<DependencyInfo>)ProjectCoordinatesView.this.dependencyListener.getDependencies());
                ProjectCoordinatesView.this.refreshTableUI();
                return Status.OK_STATUS;
            }
        };
    }

    private void refreshTableUI() {
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.locationColumn.setLabelProvider((CellLabelProvider)new LocationTooltip());
        this.coordinateColumn.setLabelProvider((CellLabelProvider)new CoordinateTooltip());
        this.tableViewer.refresh();
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    @Subscribe
    public void onEvent(ModelEvents.AdvisorConfigurationChangedEvent e) throws IOException {
        this.refreshData();
    }

    private static Optional<ProjectCoordinate> findFirstMatchingCoordinate(Collection<Optional<ProjectCoordinate>> pcs) {
        return Optional.fromNullable((Object)((ProjectCoordinate)Iterables.getFirst((Iterable)Optional.presentInstances(pcs), null)));
    }

    private DependencyInfo extractDependencyInfo(Object obj) {
        Map.Entry entry = (Map.Entry)Checks.cast((Object)obj);
        return (DependencyInfo)entry.getKey();
    }

    private Collection<Optional<ProjectCoordinate>> extractProjectCoordinates(Object obj) {
        Map.Entry entry = (Map.Entry)Checks.cast((Object)obj);
        return (Collection)entry.getValue();
    }

    class ContentProvider
    implements IStructuredContentProvider {
        private ListMultimap<DependencyInfo, Optional<ProjectCoordinate>> data;
        private List<IProjectCoordinateAdvisor> strategies = Lists.newArrayList();

        public ContentProvider() {
            HashMap map = Maps.newHashMap();
            this.data = Multimaps.newListMultimap((Map)map, (Supplier)new Supplier<List<Optional<ProjectCoordinate>>>(){

                public List<Optional<ProjectCoordinate>> get() {
                    return Lists.newArrayList();
                }
            });
        }

        public void setData(Set<DependencyInfo> dependencyInfos) {
            this.data.clear();
            new ResolvingDependenciesJob(Messages.JOB_RESOLVING_DEPENDENCIES, dependencyInfos).schedule();
        }

        public List<IProjectCoordinateAdvisor> getStrategies() {
            return this.strategies;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.data.asMap().entrySet().toArray();
        }

        private final class ResolvingDependenciesJob
        extends Job {
            private final Set<DependencyInfo> dependencyInfos;

            public ResolvingDependenciesJob(String name, Set<DependencyInfo> dependencyInfos) {
                super(name);
                this.dependencyInfos = dependencyInfos;
            }

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.TASK_ASSIGNING_PROJECT_COORDINATES, this.dependencyInfos.size());
                ContentProvider.this.strategies = ProjectCoordinatesView.this.pcAdvisorsService.getAdvisors();
                for (DependencyInfo dependencyInfo : this.dependencyInfos) {
                    monitor.subTask(MessageFormat.format(Messages.TASK_ASSIGNING_PROJECT_COORDINATE_TO, dependencyInfo.getFile().getName()));
                    for (IProjectCoordinateAdvisor strategy : ContentProvider.this.strategies) {
                        ContentProvider.this.data.put((Object)dependencyInfo, (Object)strategy.suggest(dependencyInfo));
                    }
                    ContentProvider.this.data.put((Object)dependencyInfo, ProjectCoordinatesView.this.pcAdvisorsService.suggest(dependencyInfo));
                    monitor.worked(1);
                }
                this.refreshUI();
                return Status.OK_STATUS;
            }

            private void refreshUI() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ProjectCoordinatesView.this.refreshTableUI();
                    }
                });
            }
        }
    }

    class CoordinateTooltip
    extends ToolTipProvider {
        CoordinateTooltip() {
        }

        private String getDisplayName(IProjectCoordinateAdvisor advisor) {
            AdvisorDescriptor descriptor = ProjectCoordinatesView.this.pcAdvisorsService.getDescriptor(advisor);
            return descriptor.getName();
        }

        @Override
        protected String generateTooltip(Map.Entry<DependencyInfo, Collection<Optional<ProjectCoordinate>>> entry) {
            DependencyInfo dependencyInfo = entry.getKey();
            StringBuilder sb = new StringBuilder();
            List<IProjectCoordinateAdvisor> advisors = ProjectCoordinatesView.this.contentProvider.getStrategies();
            ArrayList coordinates = Lists.newArrayList((Iterable)entry.getValue());
            int i = 0;
            while (i < advisors.size()) {
                Optional optionalCoordinate;
                IProjectCoordinateAdvisor advisor = advisors.get(i);
                Optional coordinate = (Optional)coordinates.get(i);
                if (i != 0) {
                    sb.append(IOUtils.LINE_SEPARATOR);
                }
                String value = (optionalCoordinate = advisor.suggest(dependencyInfo)).isPresent() ? ((ProjectCoordinate)optionalCoordinate.get()).toString() : (coordinate.isPresent() ? ((ProjectCoordinate)coordinate.get()).toString() : Messages.TABLE_CELL_TOOLTIP_UNKNOWN_COORDINATE);
                sb.append(MessageFormat.format(Messages.TABLE_CELL_TOOLTIP_KEY_VALUE, this.getDisplayName(advisor), value));
                ++i;
            }
            return sb.toString();
        }
    }

    class LocationTooltip
    extends ToolTipProvider {
        LocationTooltip() {
        }

        @Override
        protected String generateTooltip(Map.Entry<DependencyInfo, Collection<Optional<ProjectCoordinate>>> entry) {
            DependencyInfo dependencyInfo = entry.getKey();
            StringBuilder sb = new StringBuilder();
            sb.append(MessageFormat.format(Messages.TABLE_CELL_TOOLTIP_LOCATION, dependencyInfo.getFile().getAbsolutePath()));
            sb.append(IOUtils.LINE_SEPARATOR);
            sb.append(MessageFormat.format(Messages.TABLE_CELL_TOOLTIP_TYPE, dependencyInfo.getType().toString()));
            ImmutableMap hints = dependencyInfo.getHints();
            if (hints != null && !hints.isEmpty()) {
                sb.append(IOUtils.LINE_SEPARATOR);
                sb.append(Messages.TABLE_CELL_TOOLTIP_HINTS);
                for (Map.Entry hint : hints.entrySet()) {
                    sb.append(IOUtils.LINE_SEPARATOR);
                    sb.append("  ");
                    sb.append(MessageFormat.format(Messages.TABLE_CELL_TOOLTIP_KEY_VALUE, hint.getKey(), hint.getValue()));
                }
            }
            return sb.toString();
        }
    }

    class ProjectCoordinateEditing
    extends EditingSupport {
        private String formerValue;
        private final ComboBoxViewerCellEditor editor;

        public ProjectCoordinateEditing(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.editor = new ComboBoxViewerCellEditor((Composite)viewer.getTable());
            this.editor.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.editor.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
        }

        protected CellEditor getCellEditor(Object element) {
            if (element instanceof Map.Entry) {
                HashSet values = Sets.newHashSet();
                Collection value = ProjectCoordinatesView.this.extractProjectCoordinates(element);
                for (ProjectCoordinate pc : Optional.presentInstances((Iterable)value)) {
                    values.add(pc.toString());
                }
                this.editor.setInput((Object)values);
            }
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            if (element instanceof Map.Entry) {
                Collection pcs = ProjectCoordinatesView.this.extractProjectCoordinates(element);
                Optional optionalFirstMatchingCoordinate = ProjectCoordinatesView.findFirstMatchingCoordinate(pcs);
                this.formerValue = optionalFirstMatchingCoordinate.isPresent() ? ((ProjectCoordinate)optionalFirstMatchingCoordinate.get()).toString() : "";
                return this.formerValue;
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            if (value == null && this.editor.getControl() instanceof CCombo) {
                value = ((CCombo)this.editor.getControl()).getText();
            }
            if (Objects.equal((Object)value, (Object)this.formerValue)) {
                return;
            }
            if (element instanceof Map.Entry) {
                DependencyInfo dependencyInfo = ProjectCoordinatesView.this.extractDependencyInfo(element);
                if ("".equals(value)) {
                    ProjectCoordinatesView.this.manualPcAdvisor.removeManualMapping(dependencyInfo);
                    ProjectCoordinatesView.this.bus.post((Object)new ModelEvents.ProjectCoordinateChangeEvent(dependencyInfo));
                } else {
                    try {
                        ProjectCoordinate valueOf = ProjectCoordinate.valueOf((String)((String)value));
                        ProjectCoordinatesView.this.manualPcAdvisor.setManualMapping(dependencyInfo, valueOf);
                        ProjectCoordinatesView.this.bus.post((Object)new ModelEvents.ProjectCoordinateChangeEvent(dependencyInfo));
                    }
                    catch (Exception exception) {
                        MessageDialog.openError((Shell)ProjectCoordinatesView.this.table.getShell(), (String)Messages.DIALOG_TITLE_INVALID_COORDINATE_FORMAT, (String)MessageFormat.format(Messages.DIALOG_MESSAGE_INVALID_COORDINATE_FORMAT, value));
                        return;
                    }
                }
            }
            ProjectCoordinatesView.this.refreshData();
        }
    }

    class TableFilterAction
    extends Action {
        private final ViewerFilter filter;

        public TableFilterAction(String text, int style, ViewerFilter filter) {
            super(text, style);
            this.filter = filter;
        }

        public void run() {
            if (this.isChecked()) {
                if (!this.isFilterAlreadyAdded()) {
                    ProjectCoordinatesView.this.tableViewer.addFilter(this.filter);
                }
            } else {
                ProjectCoordinatesView.this.tableViewer.removeFilter(this.filter);
            }
            ProjectCoordinatesView.this.refreshTableUI();
        }

        private boolean isFilterAlreadyAdded() {
            ViewerFilter[] viewerFilterArray = ProjectCoordinatesView.this.tableViewer.getFilters();
            int n = viewerFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter viewerFilter = viewerFilterArray[n2];
                if (viewerFilter.equals(this.filter)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    abstract class ToolTipProvider
    extends CellLabelProvider {
        ToolTipProvider() {
        }

        public void update(ViewerCell cell) {
            cell.setText(cell.getText());
        }

        public String getToolTipText(Object element) {
            if (element instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)Checks.cast((Object)element);
                return this.generateTooltip(entry);
            }
            return "";
        }

        protected abstract String generateTooltip(Map.Entry<DependencyInfo, Collection<Optional<ProjectCoordinate>>> var1);

        public Point getToolTipShift(Object object) {
            return new Point(5, 5);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 100;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 10000;
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)Checks.cast((Object)obj);
                DependencyInfo dependencyInfo = (DependencyInfo)entry.getKey();
                switch (index) {
                    case 0: {
                        String name = dependencyInfo.getFile().getName();
                        switch (dependencyInfo.getType()) {
                            case JRE: {
                                return (String)dependencyInfo.getHint("EXECUTION_ENVIRONMENT").or((Object)name);
                            }
                            case PROJECT: {
                                return (String)dependencyInfo.getHint("PROJECT_NAME").or((Object)name);
                            }
                        }
                        return name;
                    }
                    case 1: {
                        Optional pc = (Optional)Iterables.getLast((Iterable)((Iterable)entry.getValue()), (Object)Optional.absent());
                        if (!pc.isPresent()) break;
                        return ((ProjectCoordinate)pc.get()).toString();
                    }
                }
                return "";
            }
            return "";
        }

        public Image getColumnImage(Object obj, int index) {
            if (obj instanceof Map.Entry) {
                DependencyInfo dependencyInfo = ProjectCoordinatesView.this.extractDependencyInfo(obj);
                switch (index) {
                    case 0: {
                        return this.getImageForDependencyTyp(dependencyInfo);
                    }
                }
                return null;
            }
            return null;
        }

        private Image getImageForDependencyTyp(DependencyInfo dependencyInfo) {
            switch (dependencyInfo.getType()) {
                case JRE: {
                    return ProjectCoordinatesView.this.images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_JRE);
                }
                case JAR: {
                    return ProjectCoordinatesView.this.images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_JAR);
                }
                case PROJECT: {
                    return ProjectCoordinatesView.this.images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_JAVA_PROJECT);
                }
            }
            return null;
        }
    }
}

