/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.eclipse.recommenders.models.Coordinates;
import org.eclipse.recommenders.models.IModelArchiveCoordinateAdvisor;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.ModelCoordinate;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.utils.Artifacts;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.Version;
import org.eclipse.recommenders.utils.Versions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.util.artifact.DefaultArtifact;

public class ModelIndex
implements IModelArchiveCoordinateAdvisor,
IModelIndex {
    private static final int MAX_DOCUMENTS_SEARCHED = 100;
    private File indexdir;
    private Directory index;
    private IndexReader reader;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public ModelIndex(File indexdir) {
        this.indexdir = indexdir;
    }

    @VisibleForTesting
    ModelIndex(Directory index) {
        this.index = index;
    }

    public boolean isAccessible() {
        return this.index != null && this.reader != null;
    }

    @Override
    public void open() throws IOException {
        if (this.indexdir != null) {
            this.index = FSDirectory.open((File)this.indexdir);
        }
        this.reader = IndexReader.open((Directory)this.index);
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly((Closeable)this.reader);
        IOUtils.closeQuietly((Closeable)this.index);
    }

    @Override
    public Optional<ModelCoordinate> suggest(ProjectCoordinate pc, String modelType) {
        ImmutableSet<ModelCoordinate> results = this.suggestCandidates(pc, modelType);
        if (results.isEmpty()) {
            return Optional.absent();
        }
        final Version closestVersion = Versions.findClosest((Version)Version.valueOf((String)pc.getVersion()), (Collection)Collections2.transform(results, (Function)new Function<ModelCoordinate, Version>(){

            public Version apply(ModelCoordinate mc) {
                return Version.valueOf((String)mc.getVersion());
            }
        }));
        return Optional.of((Object)((ModelCoordinate)Iterables.find(results, (Predicate)new Predicate<ModelCoordinate>(){

            public boolean apply(ModelCoordinate mc) {
                return Version.valueOf((String)mc.getVersion()).equals((Object)closestVersion);
            }
        })));
    }

    @Override
    public ImmutableSet<ModelCoordinate> suggestCandidates(ProjectCoordinate pc, String modelType) {
        Checks.ensureIsNotNull((Object)modelType);
        if (!this.isAccessible()) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder res = ImmutableSet.builder();
        for (String model : this.queryLuceneIndexForModelCandidates(pc, modelType)) {
            Artifact tmp = Artifacts.asArtifact((String)model);
            ModelCoordinate mc = ModelIndex.toModelCoordinate(tmp);
            res.add((Object)mc);
        }
        return res.build();
    }

    private Set<String> queryLuceneIndexForModelCandidates(ProjectCoordinate pc, String modelClassifier) {
        BooleanQuery query = new BooleanQuery();
        Term coordTerm = new Term("coordinate", String.format("%s:%s:*", pc.getGroupId(), pc.getArtifactId()));
        WildcardQuery coordQuery = new WildcardQuery(coordTerm);
        query.add((Query)coordQuery, BooleanClause.Occur.MUST);
        query.add((Query)new TermQuery(new Term("classifier", modelClassifier)), BooleanClause.Occur.MUST);
        try {
            IndexSearcher searcher = new IndexSearcher(this.reader);
            TopDocs matches = searcher.search((Query)query, 100);
            searcher.close();
            HashSet results = Sets.newHashSet();
            ScoreDoc[] scoreDocArray = matches.scoreDocs;
            int n = matches.scoreDocs.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreDoc scoreDoc = scoreDocArray[n2];
                Document doc = this.reader.document(scoreDoc.doc);
                String modelcoord = doc.get(modelClassifier);
                results.add(modelcoord);
                ++n2;
            }
            return results;
        }
        catch (Exception exception) {
            return Collections.emptySet();
        }
    }

    @Override
    public ImmutableSet<ModelCoordinate> getKnownModels(String modelType) {
        List<Artifact> artifacts = this.findModelArchiveCoordinatesByClassifier(modelType);
        Collection transform = Collections2.transform(artifacts, (Function)new Artifact2ModelArchiveTransformer());
        return ImmutableSet.copyOf((Collection)transform);
    }

    private List<Artifact> findModelArchiveCoordinatesByClassifier(String classifier) {
        if (!this.isAccessible()) {
            return Collections.emptyList();
        }
        LinkedList res = Lists.newLinkedList();
        try {
            Term t = new Term("classifier", classifier);
            IndexSearcher searcher = new IndexSearcher(this.reader);
            TopDocs matches = searcher.search((Query)new TermQuery(t), Integer.MAX_VALUE);
            searcher.close();
            ScoreDoc[] scoreDocArray = matches.scoreDocs;
            int n = matches.scoreDocs.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreDoc doc = scoreDocArray[n2];
                String value = this.reader.document(doc.doc).get(classifier);
                if (value != null) {
                    res.add(Artifacts.newArtifact((String)value));
                }
                ++n2;
            }
        }
        catch (Exception e) {
            this.log.error("Searching index failed with exception", (Throwable)e);
        }
        return res;
    }

    @Override
    public Optional<ProjectCoordinate> suggestProjectCoordinateByArtifactId(String artifactId) {
        Term t1 = new Term("symbolic-names", artifactId);
        return this.findProjectCoordinateByTerm(t1);
    }

    @Override
    public Optional<ProjectCoordinate> suggestProjectCoordinateByFingerprint(String fingerprint) {
        Term t1 = new Term("fingerprints", fingerprint);
        return this.findProjectCoordinateByTerm(t1);
    }

    private Optional<ProjectCoordinate> findProjectCoordinateByTerm(Term ... terms) {
        TopDocs matches;
        if (this.reader == null) {
            return Optional.absent();
        }
        BooleanQuery query = new BooleanQuery();
        Term[] termArray = terms;
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            Term t = termArray[n2];
            TermQuery q = new TermQuery(t);
            query.add((Query)q, BooleanClause.Occur.MUST);
            ++n2;
        }
        try {
            IndexSearcher searcher = new IndexSearcher(this.reader);
            matches = searcher.search((Query)query, 100);
            searcher.close();
        }
        catch (IOException iOException) {
            return Optional.absent();
        }
        int i = 0;
        while (i < Math.min(matches.scoreDocs.length, 100)) {
            block8: {
                DefaultArtifact tmp;
                Optional<ProjectCoordinate> pc;
                Document doc;
                try {
                    doc = this.reader.document(matches.scoreDocs[i].doc);
                }
                catch (IOException iOException) {
                    break block8;
                }
                String string = doc.get("coordinate");
                if (string != null && (pc = Coordinates.tryNewProjectCoordinate((tmp = new DefaultArtifact(string)).getGroupId(), tmp.getArtifactId(), Versions.canonicalizeVersion((String)tmp.getVersion()))).isPresent()) {
                    return pc;
                }
            }
            ++i;
        }
        return Optional.absent();
    }

    private static ModelCoordinate toModelCoordinate(Artifact a) {
        return new ModelCoordinate(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getExtension(), a.getVersion());
    }

    private static final class Artifact2ModelArchiveTransformer
    implements Function<Artifact, ModelCoordinate> {
        private Artifact2ModelArchiveTransformer() {
        }

        public ModelCoordinate apply(Artifact a) {
            return ModelIndex.toModelCoordinate(a);
        }
    }
}

