/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import org.apache.maven.repository.internal.DefaultVersionRangeResolver;
import org.apache.maven.repository.internal.DefaultVersionResolver;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.maven.repository.internal.SnapshotMetadataGeneratorFactory;
import org.apache.maven.repository.internal.VersionsMetadataGeneratorFactory;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.providers.file.FileWagon;
import org.eclipse.recommenders.models.DownloadCallback;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.ModelCoordinate;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.connector.wagon.WagonProvider;
import org.sonatype.aether.connector.wagon.WagonRepositoryConnectorFactory;
import org.sonatype.aether.impl.ArtifactDescriptorReader;
import org.sonatype.aether.impl.MetadataGeneratorFactory;
import org.sonatype.aether.impl.VersionRangeResolver;
import org.sonatype.aether.impl.VersionResolver;
import org.sonatype.aether.impl.internal.DefaultServiceLocator;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.spi.connector.RepositoryConnectorFactory;
import org.sonatype.aether.transfer.TransferCancelledException;
import org.sonatype.aether.transfer.TransferEvent;
import org.sonatype.aether.transfer.TransferListener;
import org.sonatype.aether.util.DefaultRepositorySystemSession;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.maven.wagon.AhcWagon;

public class ModelRepository
implements IModelRepository {
    private final File basedir;
    private final RemoteRepository remoteRepo;
    private final RepositorySystem system;
    private final RepositorySystemSession defaultSession;
    private final Map<ModelCoordinate, Optional<File>> inProgressResolutions = Maps.newHashMap();

    public ModelRepository(File basedir, String remoteUrl) throws Exception {
        this.basedir = basedir;
        this.remoteRepo = this.createRemoteRepository(remoteUrl);
        this.system = this.createRepositorySystem();
        this.defaultSession = this.createDefaultSession();
    }

    private RemoteRepository createRemoteRepository(String url) {
        return new RemoteRepository("models", "default", url);
    }

    private RepositorySystem createRepositorySystem() throws Exception {
        DefaultServiceLocator locator = new DefaultServiceLocator();
        locator.addService(VersionResolver.class, DefaultVersionResolver.class);
        locator.addService(VersionRangeResolver.class, DefaultVersionRangeResolver.class);
        locator.addService(ArtifactDescriptorReader.class, DefaultArtifactDescriptorReader.class);
        locator.addService(MetadataGeneratorFactory.class, SnapshotMetadataGeneratorFactory.class);
        locator.addService(MetadataGeneratorFactory.class, VersionsMetadataGeneratorFactory.class);
        locator.addService(RepositoryConnectorFactory.class, WagonRepositoryConnectorFactory.class);
        locator.setServices(WagonProvider.class, (Object[])new WagonProvider[]{new ManualWagonProvider()});
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    private RepositorySystemSession createDefaultSession() {
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        LocalRepository localRepo = new LocalRepository(this.basedir);
        session.setLocalRepositoryManager(this.system.newLocalRepositoryManager(localRepo));
        session.setIgnoreMissingArtifactDescriptor(true);
        session.setChecksumPolicy("fail");
        session.setConfigProperty("aether.artifactResolver.snapshotNormalization", (Object)false);
        session.setConfigProperty("aether.versionResolver.noCache", (Object)true);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<File> getLocation(ModelCoordinate mc, boolean prefetch) {
        Map<ModelCoordinate, Optional<File>> map = this.inProgressResolutions;
        synchronized (map) {
            if (this.inProgressResolutions.containsKey(mc)) {
                return this.inProgressResolutions.get(mc);
            }
            RepositorySystemSession offlineSession = this.newOfflineSession();
            return this.resolveInternal(mc, offlineSession);
        }
    }

    @Override
    public Optional<File> resolve(ModelCoordinate mc, boolean force) {
        return this.resolve(mc, force, DownloadCallback.NULL);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Optional<File> resolve(ModelCoordinate mc, boolean force, DownloadCallback callback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Optional<File> resolveInternal(ModelCoordinate mc, RepositorySystemSession session) {
        try {
            Artifact coord = this.toSnapshotArtifact(mc);
            ArtifactRequest request = new ArtifactRequest(coord, Collections.singletonList(this.remoteRepo), null);
            ArtifactResult result = this.system.resolveArtifact(session, request);
            return Optional.of((Object)result.getArtifact().getFile());
        }
        catch (ArtifactResolutionException artifactResolutionException) {
            return Optional.absent();
        }
    }

    private RepositorySystemSession newOfflineSession() {
        DefaultRepositorySystemSession offlineSession = new DefaultRepositorySystemSession(this.defaultSession);
        offlineSession.setOffline(true);
        return offlineSession;
    }

    private DefaultRepositorySystemSession newOnlineSession(final DownloadCallback callback, boolean forceDownloads) {
        DefaultRepositorySystemSession onlineSession = new DefaultRepositorySystemSession(this.defaultSession);
        if (forceDownloads) {
            onlineSession.setUpdatePolicy("always");
            onlineSession.setNotFoundCachingEnabled(false);
            onlineSession.setTransferErrorCachingEnabled(false);
        } else {
            onlineSession.setUpdatePolicy("interval:60");
            onlineSession.setNotFoundCachingEnabled(true);
            onlineSession.setTransferErrorCachingEnabled(true);
        }
        onlineSession.setTransferListener(new TransferListener(){

            public void transferInitiated(TransferEvent e) throws TransferCancelledException {
                callback.downloadInitiated(e.getResource().getResourceName());
            }

            public void transferStarted(TransferEvent e) throws TransferCancelledException {
                callback.downloadStarted(e.getResource().getResourceName());
            }

            public void transferProgressed(TransferEvent e) throws TransferCancelledException {
                callback.downloadProgressed(e.getResource().getResourceName(), e.getTransferredBytes(), e.getResource().getContentLength());
            }

            public void transferSucceeded(TransferEvent e) {
                callback.downloadSucceeded(e.getResource().getResourceName());
            }

            public void transferFailed(TransferEvent e) {
                callback.downloadFailed(e.getResource().getResourceName());
            }

            public void transferCorrupted(TransferEvent e) throws TransferCancelledException {
                callback.downloadCorrupted(e.getResource().getResourceName());
            }
        });
        return onlineSession;
    }

    @Beta
    public void setProxy(String type, String host, int port, String user, String pass) {
        Authentication auth = user == null ? null : new Authentication(user, pass);
        Proxy proxy = type == null ? null : new Proxy(type, host, port, auth);
        this.remoteRepo.setProxy(proxy);
    }

    @Beta
    public void unsetProxy() {
        this.remoteRepo.setProxy(null);
    }

    @Beta
    public void setAuthentication(String user, String pass) {
        this.remoteRepo.setAuthentication(new Authentication(user, pass));
    }

    public String toString() {
        return this.basedir.getAbsolutePath();
    }

    private Artifact toSnapshotArtifact(ModelCoordinate mc) {
        return new DefaultArtifact(mc.getGroupId(), mc.getArtifactId(), mc.getClassifier(), mc.getExtension(), String.valueOf(mc.getVersion()) + "-SNAPSHOT");
    }

    private static class ManualWagonProvider
    implements WagonProvider {
        private ManualWagonProvider() {
        }

        public Wagon lookup(String roleHint) throws Exception {
            if ("http".equals(roleHint) || "https".equals(roleHint)) {
                AhcWagon ahcWagon = new AhcWagon();
                ahcWagon.setTimeout(300000);
                return ahcWagon;
            }
            if ("file".equals(roleHint)) {
                return new FileWagon();
            }
            return null;
        }

        public void release(Wagon wagon) {
        }
    }
}

