/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models.advisors;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.recommenders.models.Coordinates;
import org.eclipse.recommenders.models.DependencyInfo;
import org.eclipse.recommenders.models.DependencyType;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.models.advisors.AbstractProjectCoordinateAdvisor;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.Versions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenPomXmlAdvisor
extends AbstractProjectCoordinateAdvisor {
    private Logger log = LoggerFactory.getLogger(MavenPomXmlAdvisor.class);

    @Override
    protected Optional<ProjectCoordinate> doSuggest(DependencyInfo dependencyInfo) {
        try {
            File pomfile = new File(dependencyInfo.getFile(), "pom.xml");
            if (!pomfile.exists()) {
                return Optional.absent();
            }
            Model model = this.readModelFromFile(pomfile);
            return this.extractProjectCoordinateFromModel(model);
        }
        catch (Exception e) {
            this.log.error("Could not read pom.xml file of dependency :" + dependencyInfo, (Throwable)e);
            return Optional.absent();
        }
    }

    private Model readModelFromFile(File pomfile) throws FileNotFoundException, IOException, XmlPullParserException {
        Model model;
        InputStreamReader pomInputStream = null;
        try {
            MavenXpp3Reader mavenReader = new MavenXpp3Reader();
            pomInputStream = new InputStreamReader((InputStream)new FileInputStream(pomfile), this.detectFileEncoding(pomfile));
            model = mavenReader.read((Reader)pomInputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(pomInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)pomInputStream);
        return model;
    }

    private Charset detectFileEncoding(File file) throws IOException {
        FileInputStream input;
        block5: {
            int first;
            block6: {
                block4: {
                    Charset charset;
                    input = null;
                    try {
                        input = new FileInputStream(file);
                        first = input.read();
                        if (first != 239) break block4;
                        int second = input.read();
                        int third = input.read();
                        if (second != 187 || third != 191) break block5;
                        charset = Charsets.UTF_8;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(input);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Closeable)input);
                    return charset;
                }
                if (first != 254) break block6;
                if (input.read() != 255) break block5;
                Charset charset = Charsets.UTF_16BE;
                IOUtils.closeQuietly((Closeable)input);
                return charset;
            }
            if (first != 255 || input.read() != 254) break block5;
            Charset charset = Charsets.UTF_16LE;
            IOUtils.closeQuietly((Closeable)input);
            return charset;
        }
        IOUtils.closeQuietly((Closeable)input);
        return Charset.defaultCharset();
    }

    private Optional<ProjectCoordinate> extractProjectCoordinateFromModel(Model model) {
        String groupId = model.getGroupId();
        String artifactId = model.getArtifactId();
        String version = model.getVersion();
        Parent parent = model.getParent();
        if (parent != null) {
            if (groupId == null) {
                groupId = parent.getGroupId();
            }
            if (version == null) {
                version = parent.getVersion();
            }
        }
        if (groupId == null || artifactId == null || version == null) {
            return Optional.absent();
        }
        if (this.containsPropertyReference(groupId) || this.containsPropertyReference(artifactId) || this.containsPropertyReference(version)) {
            return Optional.absent();
        }
        int indexOf = version.indexOf(45);
        version = version.substring(0, indexOf == -1 ? version.length() : indexOf);
        return Coordinates.tryNewProjectCoordinate(groupId, artifactId, Versions.canonicalizeVersion((String)version));
    }

    private boolean containsPropertyReference(String string) {
        return string.contains("$");
    }

    @Override
    public boolean isApplicable(DependencyType type) {
        return DependencyType.PROJECT == type;
    }
}

