/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models.advisors;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.eclipse.recommenders.models.Coordinates;
import org.eclipse.recommenders.models.DependencyInfo;
import org.eclipse.recommenders.models.DependencyType;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.models.advisors.AbstractProjectCoordinateAdvisor;
import org.eclipse.recommenders.models.advisors.OsgiVersionParser;
import org.eclipse.recommenders.utils.Artifacts;
import org.eclipse.recommenders.utils.Versions;
import org.eclipse.recommenders.utils.Zips;

public class OsgiManifestAdvisor
extends AbstractProjectCoordinateAdvisor {
    public static final Attributes.Name BUNDLE_NAME = new Attributes.Name("Bundle-SymbolicName");
    public static final Attributes.Name BUNDLE_VERSION = new Attributes.Name("Bundle-Version");
    private Zips.IFileToJarFileConverter jarFileConverter;

    public OsgiManifestAdvisor() {
        this.jarFileConverter = new Zips.DefaultJarFileConverter();
    }

    @VisibleForTesting
    public OsgiManifestAdvisor(Zips.IFileToJarFileConverter fileToJarFileConverter) {
        this.jarFileConverter = fileToJarFileConverter;
    }

    @Override
    protected Optional<ProjectCoordinate> doSuggest(DependencyInfo dependencyInfo) {
        Optional<Manifest> optionalManifest = Optional.absent();
        if (dependencyInfo.getType() == DependencyType.JAR) {
            optionalManifest = this.extractManifestFromJar(dependencyInfo);
        } else if (dependencyInfo.getType() == DependencyType.PROJECT) {
            optionalManifest = this.extractManifestFromProject(dependencyInfo);
        }
        if (optionalManifest.isPresent()) {
            return this.extractProjectCoordinateFromManifest((Manifest)optionalManifest.get());
        }
        return Optional.absent();
    }

    private Optional<Manifest> extractManifestFromProject(DependencyInfo dependencyInfo) {
        File projectFolder = dependencyInfo.getFile();
        File manifestFile = new File(projectFolder, "META-INF" + File.separator + "MANIFEST.MF");
        if (manifestFile.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(manifestFile);
                Manifest manifest = new Manifest(fileInputStream);
                fileInputStream.close();
                return Optional.of((Object)manifest);
            }
            catch (IOException iOException) {
                return Optional.absent();
            }
        }
        return Optional.absent();
    }

    private Optional<Manifest> extractManifestFromJar(DependencyInfo dependencyInfo) {
        Optional optionalJarFile = this.jarFileConverter.createJarFile(dependencyInfo.getFile());
        if (!optionalJarFile.isPresent()) {
            return Optional.absent();
        }
        JarFile jarFile = (JarFile)optionalJarFile.get();
        try {
            Manifest manifest = jarFile.getManifest();
            Optional optional = Optional.fromNullable((Object)manifest);
            return optional;
        }
        catch (IOException iOException) {
            Optional optional = Optional.absent();
            return optional;
        }
        finally {
            Zips.closeQuietly((ZipFile)jarFile);
        }
    }

    private Optional<ProjectCoordinate> extractProjectCoordinateFromManifest(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        String bundleName = attributes.getValue(BUNDLE_NAME);
        String bundleVersion = attributes.getValue(BUNDLE_VERSION);
        if (bundleName == null || bundleVersion == null) {
            return Optional.absent();
        }
        int indexOf = bundleName.indexOf(59);
        String artifactId = bundleName.substring(0, indexOf == -1 ? bundleName.length() : indexOf);
        String groupId = Artifacts.guessGroupId((String)artifactId);
        Optional<String> version = OsgiVersionParser.parse(bundleVersion);
        if (version.isPresent()) {
            return Coordinates.tryNewProjectCoordinate(groupId, artifactId, Versions.canonicalizeVersion((String)((String)version.get())));
        }
        return Optional.absent();
    }

    @Override
    public boolean isApplicable(DependencyType type) {
        return DependencyType.JAR == type || DependencyType.PROJECT == type;
    }
}

