/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp;

import java.text.MessageFormat;
import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.recommenders.internal.rcp.Constants;
import org.eclipse.recommenders.internal.rcp.Messages;
import org.eclipse.recommenders.internal.rcp.PreferenceLinkDialog;
import org.eclipse.recommenders.internal.rcp.RcpPreferences;
import org.eclipse.recommenders.rcp.utils.PreferencesHelper;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShowSurveyDialogJob
extends UIJob {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final RcpPreferences prefs;
    private final Provider<IWebBrowser> browser;

    @Inject
    public ShowSurveyDialogJob(RcpPreferences prefs, Provider<IWebBrowser> browser) {
        super("");
        this.prefs = prefs;
        this.browser = browser;
        this.setSystem(true);
    }

    public boolean shouldRun() {
        if (this.surveyAlreadyTakenOrOptOut()) {
            return false;
        }
        return this.enoughActivationsForSurvey() && this.enoughTimeForActiviation();
    }

    private boolean surveyAlreadyTakenOrOptOut() {
        return this.prefs.surveyTaken || this.prefs.surveyOptOut;
    }

    private boolean enoughActivationsForSurvey() {
        int numberOfActivations = this.prefs.numberOfActivations;
        this.prefs.setNumberOfActivations(++numberOfActivations);
        return numberOfActivations >= 20;
    }

    private boolean enoughTimeForActiviation() {
        long firstActivationDate;
        long currentTime = System.currentTimeMillis();
        long timeSinceFirstActivation = currentTime - (firstActivationDate = this.prefs.firstActivationDate);
        return timeSinceFirstActivation > Constants.SURVEY_MILLIS_BEFORE_SHOW_DIALOG;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        new PreferenceLinkDialog(this.getDisplay().getActiveShell(), Messages.DIALOG_TITLE_SURVEY, null, Messages.DIALOG_MESSAGE_SURVEY, 3, new String[]{Messages.BUTTON_LABEL_YES, Messages.BUTTON_LABEL_NO}, 0, MessageFormat.format(Messages.LINK_LABEL_TAKE_SURVEY_LATER, PreferencesHelper.createLinkLabelToPreferencePage("org.eclipse.recommenders.rcp.survey.preferencepage")), "org.eclipse.recommenders.rcp.survey.preferencepage"){

            protected void buttonPressed(int buttonId) {
                if (buttonId == 0) {
                    ShowSurveyDialogJob.this.prefs.setSurveyTaken(true);
                    try {
                        ((IWebBrowser)ShowSurveyDialogJob.this.browser.get()).openURL(Constants.SURVEY_URL);
                    }
                    catch (PartInitException e) {
                        ShowSurveyDialogJob.this.log.error("Exception occured while opening survey dialog", (Throwable)e);
                    }
                } else {
                    ShowSurveyDialogJob.this.prefs.setSurveyOptOut(true);
                }
                super.buttonPressed(buttonId);
            }
        }.open();
        return Status.OK_STATUS;
    }
}

