/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp;

import javax.inject.Inject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.recommenders.internal.rcp.Constants;
import org.eclipse.recommenders.internal.rcp.Messages;
import org.eclipse.recommenders.internal.rcp.RcpPreferences;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurveyPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger LOG = LoggerFactory.getLogger(SurveyPreferencePage.class);
    private final RcpPreferences prefs;

    @Inject
    public SurveyPreferencePage(RcpPreferences prefs) {
        this.prefs = prefs;
    }

    public void init(IWorkbench workbench) {
        this.setDescription(Messages.DIALOG_MESSAGE_SURVEY);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).create());
        Link surveyLink = new Link(container, 64);
        surveyLink.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).create());
        surveyLink.setText(Messages.LINK_LABEL_TAKE_SURVEY);
        surveyLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
                    browser.openURL(Constants.SURVEY_URL);
                    SurveyPreferencePage.this.prefs.setSurveyTaken(true);
                }
                catch (PartInitException e) {
                    LOG.error("Failed to open browser for taking the survey", (Throwable)e);
                }
            }
        });
        return container;
    }
}

