/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.rcp;

import com.google.common.base.Optional;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.codeassist.impl.AssistSourceMethod;
import org.eclipse.jdt.internal.codeassist.impl.AssistSourceType;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.recommenders.rcp.utils.JdtUtils;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.IName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.Names;
import org.eclipse.recommenders.utils.names.VmMethodName;
import org.eclipse.recommenders.utils.names.VmTypeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaElementResolver {
    private static final Logger LOG = LoggerFactory.getLogger(JavaElementResolver.class);
    public static JavaElementResolver INSTANCE;
    private final BiMap<IName, IJavaElement> cache = HashBiMap.create();
    public HashSet<IMethodName> failedRecMethods = Sets.newHashSet();
    public HashSet<ITypeName> failedRecTypes = Sets.newHashSet();

    public JavaElementResolver() {
        INSTANCE = this;
    }

    public Optional<IType> toJdtType(ITypeName recType) {
        Checks.ensureIsNotNull((Object)recType);
        if (this.failedRecTypes.contains(recType)) {
            return Optional.absent();
        }
        IType jdtType = (IType)this.cache.get((Object)recType);
        if (jdtType == null) {
            jdtType = (IType)this.resolveType(recType).orNull();
            if (jdtType != null) {
                this.registerRecJdtElementPair((IName)recType, (IJavaElement)jdtType);
            } else {
                this.failedRecTypes.add(recType);
            }
        } else if (!jdtType.exists()) {
            this.cache.remove((Object)recType);
            return this.toJdtType(recType);
        }
        return Optional.fromNullable((Object)jdtType);
    }

    public ITypeName toRecType(IType jdtType) {
        Checks.ensureIsNotNull((Object)jdtType);
        jdtType = (IType)JdtUtils.resolveJavaElementProxy((IJavaElement)jdtType);
        ITypeName recType = (ITypeName)this.cache.inverse().get((Object)jdtType);
        if (recType == null) {
            String fullyQualifiedName = jdtType.getFullyQualifiedName();
            fullyQualifiedName = StringUtils.substringBefore((String)fullyQualifiedName, (String)"<");
            recType = VmTypeName.get((String)(String.valueOf('L') + fullyQualifiedName.replace('.', '/')));
            this.registerRecJdtElementPair((IName)recType, (IJavaElement)jdtType);
        }
        return recType;
    }

    private Optional<IType> resolveType(final ITypeName recType) {
        Checks.ensureIsNotNull((Object)recType);
        if (recType.isArrayType()) {
            LOG.error("Array type in JavaElementResolver. Decision Bug 339806 pending...?");
            return Optional.absent();
        }
        if (recType.isNestedType()) {
            ITypeName declaringType = recType.getDeclaringType();
            String simpleName = StringUtils.substringAfterLast((String)recType.getIdentifier(), (String)"$");
            IType parent = (IType)this.resolveType(declaringType).orNull();
            if (parent != null) {
                try {
                    IType[] iTypeArray = parent.getTypes();
                    int n = iTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType nested = iTypeArray[n2];
                        String key = nested.getKey();
                        if (key.equals(String.valueOf(recType.getIdentifier()) + ';')) {
                            return Optional.fromNullable((Object)nested);
                        }
                        ++n2;
                    }
                    iTypeArray = parent.getMethods();
                    n = iTypeArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        IType m = iTypeArray[n2];
                        IJavaElement[] iJavaElementArray = m.getChildren();
                        int n3 = iJavaElementArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IJavaElement children = iJavaElementArray[n4];
                            if (children instanceof IType) {
                                IType nested = (IType)children;
                                if (nested.getKey().endsWith(String.valueOf(simpleName) + ';')) {
                                    return Optional.of((Object)nested);
                                }
                                String key = nested.getKey();
                                if (key.equals(String.valueOf(recType.getIdentifier()) + ';')) {
                                    return Optional.fromNullable((Object)nested);
                                }
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    return Optional.absent();
                }
            }
            return Optional.absent();
        }
        final IType[] res = new IType[1];
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        SearchEngine search = new SearchEngine();
        String srcTypeName = Names.vm2srcTypeName((String)recType.getIdentifier());
        SearchPattern pattern = SearchPattern.createPattern((String)srcTypeName, (int)0, (int)0, (int)64);
        try {
            search.search(pattern, SearchUtils.getDefaultSearchParticipants(), scope, new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    IType element = (IType)match.getElement();
                    if (JavaElementResolver.this.toRecType(element).equals(recType)) {
                        res[0] = element;
                    }
                }
            }, null);
        }
        catch (CoreException e) {
            Throws.throwUnhandledException((Exception)((Object)e));
        }
        return Optional.fromNullable((Object)res[0]);
    }

    private void registerRecJdtElementPair(IName recName, IJavaElement jdtElement) {
        Checks.ensureIsNotNull((Object)recName);
        Checks.ensureIsNotNull((Object)jdtElement);
        if (jdtElement instanceof AssistSourceType) {
            return;
        }
        if (jdtElement instanceof AssistSourceMethod) {
            return;
        }
        this.cache.forcePut((Object)recName, (Object)jdtElement);
    }

    public Optional<IMethod> toJdtMethod(IMethodName recMethod) {
        Checks.ensureIsNotNull((Object)recMethod);
        if (this.failedRecMethods.contains(recMethod)) {
            return Optional.absent();
        }
        IMethod jdtMethod = (IMethod)this.cache.get((Object)recMethod);
        if (jdtMethod != null && !jdtMethod.exists()) {
            jdtMethod = null;
        }
        if (jdtMethod == null) {
            jdtMethod = (IMethod)this.resolveMethod(recMethod).orNull();
            if (jdtMethod == null) {
                this.failedRecMethods.add(recMethod);
                return Optional.absent();
            }
            this.registerRecJdtElementPair((IName)recMethod, (IJavaElement)jdtMethod);
        } else if (!jdtMethod.exists()) {
            this.cache.remove((Object)recMethod);
            return this.toJdtMethod(recMethod);
        }
        return Optional.fromNullable((Object)jdtMethod);
    }

    public Optional<IMethodName> toRecMethod(IMethod jdtMethod) {
        if (jdtMethod == null) {
            return Optional.absent();
        }
        if (!jdtMethod.exists()) {
            return Optional.absent();
        }
        JdtUtils.resolveJavaElementProxy((IJavaElement)jdtMethod);
        IMethodName recMethod = (IMethodName)this.cache.inverse().get((Object)jdtMethod);
        if (recMethod == null) {
            try {
                IType jdtDeclaringType = jdtMethod.getDeclaringType();
                String[] unresolvedParameterTypes = jdtMethod.getParameterTypes();
                String[] resolvedParameterTypes = new String[unresolvedParameterTypes.length];
                int i = resolvedParameterTypes.length;
                while (i-- > 0) {
                    resolvedParameterTypes[i] = this.resolveType(jdtDeclaringType, unresolvedParameterTypes[i]);
                }
                String resolvedReturnType = this.resolveType(jdtDeclaringType, jdtMethod.getReturnType());
                String methodSignature = Names.src2vmMethod((String)(jdtMethod.isConstructor() ? "<init>" : jdtMethod.getElementName()), (String[])resolvedParameterTypes, (String)resolvedReturnType);
                ITypeName recDeclaringType = this.toRecType(jdtDeclaringType);
                recMethod = VmMethodName.get((String)recDeclaringType.getIdentifier(), (String)methodSignature);
                this.registerRecJdtElementPair((IName)recMethod, (IJavaElement)jdtMethod);
            }
            catch (Exception e) {
                LOG.error("Failed to resolve JDT method '{}': {}", new Object[]{jdtMethod, e.getMessage(), e});
                return Optional.absent();
            }
        }
        return Optional.fromNullable((Object)recMethod);
    }

    private String resolveType(IType jdtDeclaringType, String unresolvedType) {
        int arrayCount = Signature.getArrayCount((String)unresolvedType);
        String resolvedType = (String)JdtUtils.resolveUnqualifiedTypeNamesAndStripOffGenericsAndArrayDimension(unresolvedType, (IJavaElement)jdtDeclaringType).or((Object)"V");
        resolvedType = String.valueOf(resolvedType) + StringUtils.repeat((String)"[]", (int)arrayCount);
        return resolvedType;
    }

    private Optional<IMethod> resolveMethod(IMethodName recMethod) {
        Checks.ensureIsNotNull((Object)recMethod);
        try {
            IType jdtType = (IType)this.toJdtType(recMethod.getDeclaringType()).orNull();
            if (!this.isSuccessfullyResolvedType(jdtType)) {
                return Optional.absent();
            }
            List<IType> supertypes = this.createListOfSupertypes(jdtType);
            for (IType t : supertypes) {
                IMethod[] iMethodArray = t.getMethods();
                int n = iMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod m = iMethodArray[n2];
                    if (this.sameSignature(recMethod, m)) {
                        return Optional.of((Object)m);
                    }
                    ++n2;
                }
            }
            return Optional.absent();
        }
        catch (Exception e) {
            LOG.warn("Failed to resolve method '{}' in workspace: {}", new Object[]{recMethod, e.getMessage(), e});
            return Optional.absent();
        }
    }

    private List<IType> createListOfSupertypes(IType jdtType) throws JavaModelException {
        ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy((IType)jdtType);
        ArrayList supertypes = Lists.newArrayList((Object[])new IType[]{jdtType});
        IType[] iTypeArray = hierarchy.getAllSupertypes(jdtType);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType supertype = iTypeArray[n2];
            supertypes.add(supertype);
            ++n2;
        }
        if (jdtType.isInterface()) {
            iTypeArray = hierarchy.getRootClasses();
            n = iTypeArray.length;
            n2 = 0;
            while (n2 < n) {
                IType s = iTypeArray[n2];
                supertypes.add(s);
                ++n2;
            }
        }
        return supertypes;
    }

    private boolean sameSignature(IMethodName recMethod, IMethod jdtMethod) throws JavaModelException {
        if (!this.bothConstructors(recMethod, jdtMethod) && !this.sameName(recMethod, jdtMethod)) {
            return false;
        }
        ITypeName[] recTypes = recMethod.getParameterTypes();
        String[] jdtTypes = jdtMethod.getParameterTypes();
        if (!this.sameNumberOfParameters(recMethod, jdtMethod)) {
            return false;
        }
        int i = 0;
        while (i < recTypes.length) {
            Optional<ITypeName> jdtType = JdtUtils.resolveUnqualifiedJDTType(jdtTypes[i], (IJavaElement)jdtMethod);
            if (!jdtType.isPresent()) {
                return false;
            }
            if (!this.sameSimpleTypes(recTypes[i], (ITypeName)jdtType.get()) || !this.sameArrayDimensions(recTypes[i], jdtTypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean sameSimpleTypes(ITypeName t1, ITypeName t2) {
        return t1.getClassName().equals(t2.getClassName());
    }

    private boolean sameArrayDimensions(ITypeName t1, String jdtTypes) {
        int dim2;
        int dim1 = t1.getArrayDimensions();
        return dim1 == (dim2 = Signature.getArrayCount((char[])jdtTypes.toCharArray()));
    }

    private boolean sameNumberOfParameters(IMethodName recMethod, IMethod m) throws JavaModelException {
        return recMethod.getParameterTypes().length == m.getParameters().length;
    }

    private boolean sameName(IMethodName recMethod, IMethod m) {
        return recMethod.getName().equals(m.getElementName());
    }

    private boolean bothConstructors(IMethodName recMethod, IMethod m) throws JavaModelException {
        return recMethod.isInit() && m.isConstructor();
    }

    private boolean isSuccessfullyResolvedType(IType jdtType) throws JavaModelException {
        return jdtType != null && jdtType.isStructureKnown();
    }
}

