/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.rcp;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.services.IDisposable;

public final class SharedImages
implements IDisposable {
    private ImageRegistry registry = new ImageRegistry();

    public static String dlcl16(String image) {
        return "/icons/dlcl16/" + image;
    }

    public static String elcl16(String image) {
        return "/icons/elcl16/" + image;
    }

    public static String obj16(String image) {
        return "/icons/obj16/" + image;
    }

    public static String ovr16(String image) {
        return "/icons/ovr16/" + image;
    }

    public static String view16(String image) {
        return "/icons/view16/" + image;
    }

    public static String wizban(String image) {
        return "/icons/wizban/" + image;
    }

    public synchronized ImageDescriptor getDescriptor(ImageResource resource) {
        ImageDescriptor desc = this.registry.getDescriptor(SharedImages.toKey(resource));
        if (desc == null) {
            desc = this.register(resource);
        }
        return desc;
    }

    public synchronized Image getImage(ImageResource resource) {
        String key = SharedImages.toKey(resource);
        Image img = this.registry.get(key);
        if (img == null) {
            this.register(resource);
            img = this.registry.get(key);
        }
        return img;
    }

    private ImageDescriptor register(ImageResource resource) {
        ImageDescriptor desc = ImageDescriptor.createFromFile(resource.getClass(), (String)resource.getName());
        String key = SharedImages.toKey(resource);
        this.registry.put(key, desc);
        return desc;
    }

    private static String toKey(ImageResource resource) {
        return String.valueOf(resource.getClass().getName()) + '#' + resource.getName();
    }

    public void dispose() {
        this.registry.dispose();
    }

    public static interface ImageResource {
        public String getName();
    }

    public static enum Images implements ImageResource
    {
        ELCL_COLLAPSE_ALL(SharedImages.elcl16("collapseall.gif")),
        ELCL_DELETE(SharedImages.elcl16("delete.gif")),
        ELCL_EXPAND_ALL(SharedImages.elcl16("expandall.gif")),
        ELCL_REFRESH(SharedImages.elcl16("refresh_tab.gif")),
        ELCL_SYNCED(SharedImages.elcl16("synced.gif")),
        ELCL_ADD_REPOSITORY(SharedImages.elcl16("add_repository.gif")),
        ELCL_REMOVE_REPOSITORY(SharedImages.elcl16("remove_repository.gif")),
        ELCL_CLEAR(SharedImages.elcl16("clear.gif")),
        OBJ_CHECK_GREEN(SharedImages.obj16("tick_small.png")),
        OBJ_CROSS_RED(SharedImages.obj16("cross_small.png")),
        OBJ_BULLET_BLUE(SharedImages.obj16("bullet_blue.png")),
        OBJ_BULLET_GREEN(SharedImages.obj16("bullet_green.png")),
        OBJ_BULLET_ORANGE(SharedImages.obj16("bullet_orange.png")),
        OBJ_BULLET_RED(SharedImages.obj16("bullet_red.png")),
        OBJ_BULLET_STAR(SharedImages.obj16("bullet_star.png")),
        OBJ_BULLET_YELLOW(SharedImages.obj16("bullet_yellow.png")),
        OBJ_LIGHTBULB(SharedImages.obj16("lightbulb.gif")),
        OBJ_JAR(SharedImages.obj16("jar.gif")),
        OBJ_JAVA_PROJECT(SharedImages.obj16("project.gif")),
        OBJ_JRE(SharedImages.obj16("jre.gif")),
        OBJ_REPOSITORY(SharedImages.obj16("repository.gif")),
        OVR_STAR(SharedImages.ovr16("star.png")),
        VIEW_SLICE(SharedImages.view16("slice.gif"));

        private final String name;

        private Images(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

