/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.recommenders.models.Coordinates;
import org.eclipse.recommenders.models.IModelArchiveCoordinateAdvisor;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.ModelCoordinate;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.Version;
import org.eclipse.recommenders.utils.Versions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelIndex
implements IModelArchiveCoordinateAdvisor,
IModelIndex {
    private static final Logger LOG = LoggerFactory.getLogger(ModelIndex.class);
    private static final int MAX_DOCUMENTS_SEARCHED = 100;
    private final Lock readLock;
    private final Lock writeLock;
    private File indexdir;
    private Directory index;
    private IndexReader reader;
    private IndexWriter writer;

    private ModelIndex() {
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
    }

    public ModelIndex(File indexdir) {
        this();
        this.indexdir = indexdir;
    }

    @VisibleForTesting
    ModelIndex(Object index) {
        this();
        this.index = (Directory)index;
    }

    public boolean isAccessible() {
        return this.index != null && this.reader != null;
    }

    @Override
    public void open() throws IOException {
        this.writeLock.lock();
        try {
            if (this.indexdir != null) {
                this.index = FSDirectory.open((File)this.indexdir);
            }
            StandardAnalyzer analyzer = new StandardAnalyzer(org.apache.lucene.util.Version.LUCENE_35, (Set)Sets.newHashSet());
            IndexWriterConfig config = new IndexWriterConfig(org.apache.lucene.util.Version.LUCENE_35, (Analyzer)analyzer);
            this.writer = new IndexWriter(this.index, config);
            this.reader = IndexReader.open((IndexWriter)this.writer, (boolean)true);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void updateIndex(File index) throws IOException {
        if (!this.isAccessible()) {
            return;
        }
        this.writer.deleteAll();
        this.writer.addIndexes(new Directory[]{FSDirectory.open((File)index)});
        this.writer.commit();
        IndexReader newReader = IndexReader.openIfChanged((IndexReader)this.reader);
        IndexReader oldReader = this.reader;
        this.writeLock.lock();
        try {
            this.reader = newReader;
        }
        finally {
            this.writeLock.unlock();
        }
        oldReader.close();
    }

    @Override
    public void close() throws IOException {
        this.writeLock.lock();
        try {
            IOUtils.closeQuietly((Closeable)this.reader);
            IOUtils.closeQuietly((Closeable)this.writer);
            IOUtils.closeQuietly((Closeable)this.index);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Optional<ModelCoordinate> suggest(ProjectCoordinate pc, String modelType) {
        this.readLock.lock();
        try {
            ImmutableSet<ModelCoordinate> results = this.suggestCandidates(pc, modelType);
            if (results.isEmpty()) {
                Optional optional = Optional.absent();
                return optional;
            }
            final Version closestVersion = Versions.findClosest((Version)Version.valueOf((String)pc.getVersion()), (Collection)Collections2.transform(results, (Function)new Function<ModelCoordinate, Version>(){

                public Version apply(ModelCoordinate mc) {
                    return Version.valueOf((String)mc.getVersion());
                }
            }));
            Optional optional = Optional.of((Object)((ModelCoordinate)Iterables.find(results, (Predicate)new Predicate<ModelCoordinate>(){

                public boolean apply(ModelCoordinate mc) {
                    return Version.valueOf((String)mc.getVersion()).equals((Object)closestVersion);
                }
            })));
            return optional;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ImmutableSet<ModelCoordinate> suggestCandidates(ProjectCoordinate pc, String modelType) {
        Checks.ensureIsNotNull((Object)modelType);
        if (!this.isAccessible()) {
            return ImmutableSet.of();
        }
        this.readLock.lock();
        try {
            ImmutableSet.Builder res = ImmutableSet.builder();
            for (String model : this.queryLuceneIndexForModelCandidates(pc, modelType)) {
                DefaultArtifact tmp = new DefaultArtifact(model);
                ModelCoordinate mc = ModelIndex.toModelCoordinate((Artifact)tmp);
                res.add((Object)mc);
            }
            ImmutableSet immutableSet = res.build();
            return immutableSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private Set<String> queryLuceneIndexForModelCandidates(ProjectCoordinate pc, String modelClassifier) {
        BooleanQuery query = new BooleanQuery();
        Term coordTerm = new Term("coordinate", String.format("%s:%s:*", pc.getGroupId(), pc.getArtifactId()));
        WildcardQuery coordQuery = new WildcardQuery(coordTerm);
        query.add((Query)coordQuery, BooleanClause.Occur.MUST);
        query.add((Query)new TermQuery(new Term("classifier", modelClassifier)), BooleanClause.Occur.MUST);
        try {
            IndexSearcher searcher = new IndexSearcher(this.reader);
            TopDocs matches = searcher.search((Query)query, 100);
            searcher.close();
            HashSet results = Sets.newHashSet();
            ScoreDoc[] scoreDocArray = matches.scoreDocs;
            int n = matches.scoreDocs.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreDoc scoreDoc = scoreDocArray[n2];
                Document doc = this.reader.document(scoreDoc.doc);
                String modelcoord = doc.get(modelClassifier);
                results.add(modelcoord);
                ++n2;
            }
            return results;
        }
        catch (Exception exception) {
            return Collections.emptySet();
        }
    }

    @Override
    public ImmutableSet<ModelCoordinate> getKnownModels(String modelType) {
        if (!this.isAccessible()) {
            return ImmutableSet.of();
        }
        this.readLock.lock();
        try {
            List<Artifact> artifacts = this.findModelArchiveCoordinatesByClassifier(modelType);
            Collection transform = Collections2.transform(artifacts, (Function)new Artifact2ModelArchiveTransformer());
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)transform);
            return immutableSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private List<Artifact> findModelArchiveCoordinatesByClassifier(String classifier) {
        LinkedList res = Lists.newLinkedList();
        try {
            Term t = new Term("classifier", classifier);
            IndexSearcher searcher = new IndexSearcher(this.reader);
            TopDocs matches = searcher.search((Query)new TermQuery(t), Integer.MAX_VALUE);
            searcher.close();
            ScoreDoc[] scoreDocArray = matches.scoreDocs;
            int n = matches.scoreDocs.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreDoc doc = scoreDocArray[n2];
                String value = this.reader.document(doc.doc).get(classifier);
                if (value != null) {
                    res.add(new DefaultArtifact(value));
                }
                ++n2;
            }
        }
        catch (Exception e) {
            LOG.error("Searching index failed with exception", (Throwable)e);
        }
        return res;
    }

    @Override
    public Optional<ProjectCoordinate> suggestProjectCoordinateByArtifactId(String artifactId) {
        if (!this.isAccessible()) {
            return Optional.absent();
        }
        Term t1 = new Term("symbolic-names", artifactId);
        this.readLock.lock();
        try {
            Optional<ProjectCoordinate> optional = this.findProjectCoordinateByTerm(t1);
            return optional;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Optional<ProjectCoordinate> suggestProjectCoordinateByFingerprint(String fingerprint) {
        if (!this.isAccessible()) {
            return Optional.absent();
        }
        Term t1 = new Term("fingerprints", fingerprint);
        this.readLock.lock();
        try {
            Optional<ProjectCoordinate> optional = this.findProjectCoordinateByTerm(t1);
            return optional;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private Optional<ProjectCoordinate> findProjectCoordinateByTerm(Term ... terms) {
        TopDocs matches;
        BooleanQuery query = new BooleanQuery();
        Term[] termArray = terms;
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            Term t = termArray[n2];
            TermQuery q = new TermQuery(t);
            query.add((Query)q, BooleanClause.Occur.MUST);
            ++n2;
        }
        try {
            IndexSearcher searcher = new IndexSearcher(this.reader);
            matches = searcher.search((Query)query, 100);
            searcher.close();
        }
        catch (IOException iOException) {
            return Optional.absent();
        }
        int i = 0;
        while (i < Math.min(matches.scoreDocs.length, 100)) {
            block7: {
                DefaultArtifact tmp;
                Optional<ProjectCoordinate> pc;
                Document doc;
                try {
                    doc = this.reader.document(matches.scoreDocs[i].doc);
                }
                catch (IOException iOException) {
                    break block7;
                }
                String string = doc.get("coordinate");
                if (string != null && (pc = Coordinates.tryNewProjectCoordinate((tmp = new DefaultArtifact(string)).getGroupId(), tmp.getArtifactId(), Versions.canonicalizeVersion((String)tmp.getVersion()))).isPresent()) {
                    return pc;
                }
            }
            ++i;
        }
        return Optional.absent();
    }

    private static ModelCoordinate toModelCoordinate(Artifact a) {
        return new ModelCoordinate(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getExtension(), a.getVersion());
    }

    private static final class Artifact2ModelArchiveTransformer
    implements Function<Artifact, ModelCoordinate> {
        private Artifact2ModelArchiveTransformer() {
        }

        public ModelCoordinate apply(Artifact a) {
            return ModelIndex.toModelCoordinate(a);
        }
    }
}

