/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.livedoc.providers.calls;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.recommenders.apidocs.MethodSelfcallDirectives;
import org.eclipse.recommenders.apidocs.SingleZipMethodSelfCallsModelProvider;
import org.eclipse.recommenders.livedoc.providers.AbstractLiveDocProvider;
import org.eclipse.recommenders.livedoc.providers.LiveDocProviderException;
import org.eclipse.recommenders.livedoc.providers.ProviderOutput;
import org.eclipse.recommenders.livedoc.providers.calls.MethodSelfCallConfiguration;
import org.eclipse.recommenders.livedoc.utils.LiveDocUtils;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.IModelProvider;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.models.UniqueMethodName;
import org.eclipse.recommenders.utils.names.IMethodName;

public class MethodSelfCallProvider
extends AbstractLiveDocProvider<MethodSelfCallConfiguration> {
    private IModelProvider<IUniqueName<IMethodName>, MethodSelfcallDirectives> modelProvider;

    public String getId() {
        return "selfm";
    }

    public void setUp(ProjectCoordinate pc, IModelRepository repo, IModelIndex index) throws LiveDocProviderException {
        super.setUp(pc, repo, index);
        Optional modelArchive = this.fetchModelArchive("selfm");
        if (!modelArchive.isPresent()) {
            throw new LiveDocProviderException(String.format("No %s model available for given coordinate.", this.getId()));
        }
        this.modelProvider = new SingleZipMethodSelfCallsModelProvider((File)modelArchive.get());
        try {
            this.modelProvider.open();
        }
        catch (IOException iOException) {
            throw new LiveDocProviderException(String.format("Exception while opening model provider for %s models.", this.getId()));
        }
    }

    @VisibleForTesting
    void setUp(ProjectCoordinate pc, IModelProvider<IUniqueName<IMethodName>, MethodSelfcallDirectives> modelProvider) throws LiveDocProviderException {
        super.setUp(pc, null, null);
        this.modelProvider = modelProvider;
    }

    public ProviderOutput documentMethod(MethodDoc holder) {
        IMethodName asIMethodName = LiveDocUtils.asIMethodName((MethodDoc)holder);
        UniqueMethodName uniqueMethodName = new UniqueMethodName(this.getProjectCoordinate(), asIMethodName);
        Optional directives = this.modelProvider.acquireModel((IUniqueName)uniqueMethodName);
        if (!directives.isPresent()) {
            return null;
        }
        List<Map.Entry<IMethodName, Integer>> entries = this.preprocessEntries((MethodSelfcallDirectives)directives.get());
        if (entries.isEmpty()) {
            this.modelProvider.releaseModel((Object)((MethodSelfcallDirectives)directives.get()));
            return null;
        }
        this.modelProvider.releaseModel((Object)((MethodSelfcallDirectives)directives.get()));
        return this.createDoc(holder, ((MethodSelfcallDirectives)directives.get()).getNumberOfDefinitions(), entries);
    }

    private List<Map.Entry<IMethodName, Integer>> preprocessEntries(MethodSelfcallDirectives directive) {
        List<Map.Entry<IMethodName, Integer>> entries = this.sortEntries(directive.getCalls().entrySet());
        entries = this.filterByNumberThreshold(entries);
        entries = this.filterByPercentageAndTimesObservedThreshold(entries, directive.getNumberOfDefinitions());
        return entries;
    }

    private List<Map.Entry<IMethodName, Integer>> sortEntries(Set<Map.Entry<IMethodName, Integer>> entrySet) {
        ArrayList entries = Lists.newArrayList(entrySet);
        Collections.sort(entries, new Comparator<Map.Entry<IMethodName, Integer>>(){

            @Override
            public int compare(Map.Entry<IMethodName, Integer> o1, Map.Entry<IMethodName, Integer> o2) {
                return ComparisonChain.start().compare((Comparable)o2.getValue(), (Comparable)o1.getValue()).compare((Comparable)((Object)o1.getKey().getName()), (Comparable)((Object)o2.getKey().getName())).result();
            }
        });
        return entries;
    }

    private List<Map.Entry<IMethodName, Integer>> filterByNumberThreshold(List<Map.Entry<IMethodName, Integer>> entries) {
        int numberThreshold = ((MethodSelfCallConfiguration)this.getConfiguration()).getNumberThreshold();
        if (entries.size() > numberThreshold) {
            return entries.subList(0, numberThreshold);
        }
        return entries;
    }

    private List<Map.Entry<IMethodName, Integer>> filterByPercentageAndTimesObservedThreshold(List<Map.Entry<IMethodName, Integer>> entries, int numberOfDefinitions) {
        ArrayList filterd = Lists.newArrayList();
        for (Map.Entry<IMethodName, Integer> entry : entries) {
            Integer times = entry.getValue();
            if (times < ((MethodSelfCallConfiguration)this.getConfiguration()).getTimesObservedThreshold() || this.calculatePercentage(numberOfDefinitions, entry) < ((MethodSelfCallConfiguration)this.getConfiguration()).getPercentageThreshold()) continue;
            filterd.add(entry);
        }
        return filterd;
    }

    private int calculatePercentage(int numberOfDefinitions, Map.Entry<IMethodName, Integer> entry) {
        return Math.round((float)entry.getValue().intValue() * 100.0f / (float)numberOfDefinitions);
    }

    private ProviderOutput createDoc(MethodDoc holder, int numberOfDefinitions, List<Map.Entry<IMethodName, Integer>> entries) {
        StringBuilder sb = new StringBuilder();
        IMethodName holderMethod = LiveDocUtils.asIMethodName((MethodDoc)holder);
        sb.append("<dl>").append("<dt><span class=\"strong\">Self Calls:</span></dt>").append("<dd>");
        sb.append("The following methods are frequently called by implementors of ").append(LiveDocUtils.code((String)holder.name().concat(LiveDocUtils.listParameterTypes((IMethodName)holderMethod)))).append(", ");
        ClassDoc containingClass = holder.containingClass();
        if (containingClass.isInterface()) {
            sb.append("implementing");
        } else {
            sb.append("subclassing");
        }
        sb.append(" ").append(LiveDocUtils.code((String)containingClass.name())).append(":");
        sb.append("<br>").append("(Based on ").append(numberOfDefinitions).append(" direct implementations)").append("<br>").append("<br>");
        Iterator<Map.Entry<IMethodName, Integer>> it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry<IMethodName, Integer> entry = it.next();
            sb.append("<code>");
            IMethodName method = entry.getKey();
            if (method.equals(holderMethod)) {
                sb.append(LiveDocUtils.strong((String)LiveDocUtils.color((String)"#7f0055", (String)"super").concat(".")));
            }
            sb.append((CharSequence)LiveDocUtils.strong((StringBuilder)LiveDocUtils.htmlLink((ClassDoc)holder.containingClass(), (IMethodName)method))).append(LiveDocUtils.listParameterTypes((IMethodName)method));
            sb.append("</code>");
            float percentage = this.calculatePercentage(numberOfDefinitions, entry);
            sb.append(String.format(" (<font color=\"#0000FF\">%1$.0f%% - %2$d times</font>)", Float.valueOf(percentage), entry.getValue()));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("</dd>").append("</dl>");
        this.highlight(sb);
        return new ProviderOutput(sb.toString(), entries.size());
    }

    public void tearDown() throws LiveDocProviderException {
        if (this.modelProvider != null) {
            try {
                this.modelProvider.close();
            }
            catch (IOException iOException) {
                throw new LiveDocProviderException(String.format("Exception while closing model provider for %s models.", this.getId()));
            }
        }
    }

    public MethodSelfCallConfiguration newProviderConfiguration() {
        return new MethodSelfCallConfiguration();
    }
}

