/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils;

import com.google.common.base.Preconditions;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    private static final Pattern VALID_VERSIONS = Pattern.compile("\\d+\\.\\d+\\.\\d+");
    private final int major;
    private final int minor;
    private final int patch;

    public static Version valueOf(String version) {
        Preconditions.checkArgument((boolean)VALID_VERSIONS.matcher(version).matches());
        String[] components = version.split("\\.");
        return new Version(components[0], components[1], components[2]);
    }

    public Version(int major, int minor, int patch) {
        Preconditions.checkArgument((major >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((minor >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((patch >= 0 ? 1 : 0) != 0);
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public Version(String major, String minor, String patch) {
        this(Integer.valueOf(major), Integer.valueOf(minor), Integer.valueOf(patch));
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    @Override
    public int compareTo(Version that) {
        if (this.major != that.major) {
            return Integer.valueOf(this.major).compareTo(that.major);
        }
        if (this.minor != that.minor) {
            return Integer.valueOf(this.minor).compareTo(that.minor);
        }
        return Integer.valueOf(this.patch).compareTo(that.patch);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Version that = (Version)other;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch;
    }

    public String toString() {
        return String.format("%d.%d.%d", this.major, this.minor, this.patch);
    }
}

