/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models;

import com.google.common.base.Joiner;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.eclipse.recommenders.models.Coordinates;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Versions;

public class ProjectCoordinate {
    public static final ProjectCoordinate UNKNOWN = new ProjectCoordinate("UNKNOWN", "UNKNOWN", "0.0.0");
    private final String groupId;
    private final String artifactId;
    private final String version;

    public ProjectCoordinate(String groupId, String artifactId, String version) {
        Checks.ensureIsTrue((boolean)Coordinates.isValidId(groupId));
        Checks.ensureIsTrue((boolean)Coordinates.isValidId(artifactId));
        Checks.ensureIsTrue((boolean)Versions.isValidVersion((String)version));
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (boolean)false);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return Joiner.on((char)':').join((Object)this.getGroupId(), (Object)this.getArtifactId(), new Object[]{this.getVersion()});
    }

    public static ProjectCoordinate valueOf(String coord) {
        String[] segments = coord.split(":");
        Checks.ensureIsInRange((double)segments.length, (double)3.0, (double)3.0, (String)"Coordiante '%s' has invalid number of segments: %d", (Object[])new Object[]{coord, segments.length});
        return new ProjectCoordinate(segments[0], segments[1], segments[2]);
    }
}

