/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.livedoc.cli.args4j;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.recommenders.livedoc.cli.args4j.ArtifactOptionHandler;
import org.eclipse.recommenders.livedoc.cli.args4j.ExtURLOptionHandler;
import org.eclipse.recommenders.livedoc.cli.args4j.ProviderArgumentsHandler;
import org.eclipse.recommenders.livedoc.cli.args4j.ProviderCmdLineArguments;
import org.eclipse.recommenders.utils.Urls;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.StringArrayOptionHandler;
import org.kohsuke.args4j.spi.StringOptionHandler;

public class CliOptions {
    @Option(name="-sr", handler=ExtURLOptionHandler.class, usage="Maven repository containing sources JAR")
    private URL sourcesRepository = Urls.toUrl((String)"http://repo1.maven.org/maven2/");
    @Option(name="-u", handler=ExtURLOptionHandler.class, usage="Maven repository to upload Javadoc JAR to")
    private URL javadocRepository;
    @Option(name="-mr", handler=ExtURLOptionHandler.class, usage="Maven repositories containing Code Recommenders models")
    private List<URL> modelRepositories;
    @Option(name="-verbose", usage="Output messages about what Livedoc is doing")
    private boolean verbose;
    @Option(name="-debugging", usage="Debug output messages, includes full stack traces")
    private boolean debug;
    @Option(name="-Xresume", usage="Fast mode, no unpacking, no temp directory cleaning\n WARNING: For testing purposes only.")
    private boolean resume;
    @Option(name="-d", metaVar="DIRECTORY", usage="Destination directory for the Javadoc HTML output files")
    private File outputDir = new File(".", "apidocs");
    @Option(name="-jar", usage="Want to have an zipped JAR output for Javadoc? Warning: Requires '-d <DIRECTORY>'")
    private boolean jarOutput;
    @Option(name="-subpackages", metaVar="\"org.eclipse org.apache ...\"", usage="A list of packages to Javadoc (full recursively), otherwise all found packages in the maven coordinate will be used", handler=StringArrayOptionHandler.class)
    private String[] subpackages;
    @Option(name="-highlight", usage="Shall Livedoc highlight its output with a yellow background?")
    private boolean highlight;
    @Option(name="-transitive", usage="Shall Livedoc try to also resolve transitive dependencies instead of only direct ones?")
    private boolean transitive;
    @Option(name="-noDependencies", usage="Disable download of additional classpath entries via direct maven dependencies")
    private boolean noDependencies;
    @Argument(index=0, metaVar="GROUP_ID:ARTIFACT_ID:VERSION", required=true, usage="The Maven coordinate of the source artifact for which you want to generate Javadoc", handler=ArtifactOptionHandler.class)
    private Artifact coordinate;
    @Option(name="-mc", metaVar="GROUP_ID:ARTIFACT_ID:VERSION", usage="Optional Maven coordinate for the model artifact used to enhance the Javadoc. If not set, the source coordinate is used for the model", handler=ArtifactOptionHandler.class)
    private Artifact modelCoordinate;
    @Option(name="-p", handler=ProviderArgumentsHandler.class, usage="Choose Livedoc Providers and configure filter thresholds for recommendations, each Provider respectively: \n ovrm: Method Overrides\n ovrp: Method Override Patterns\n call-also: \"Call Also\" Recommendations \n selfc: Class \"Self Call\" Recommendations\n selfm: Class Method \"Self Call\" Recommendations\n analytics: Google Analytics Provider\n\n Valid thresholds are:\n -top N:  Show only the top N recommendations (all providers, except Google Analytics)\n -times N:  Show only recommendations with N or more times observed (ovrp, selfm, selfc)\n -percent N:  Show only recommendations with N or more percent (ovrm, call-also, selfm, selfc)\n\n Example: \"-p ovrm [-top 10]\"")
    private List<ProviderCmdLineArguments> providerArguments = Lists.newArrayList();
    private Map<String, String[]> providerArgumentsMap;
    @Option(name="-encoding", handler=StringOptionHandler.class, usage="Overwrite auto-guessed encoding of source files", metaVar="ENCODING")
    private String charset;
    @Option(name="-splitIndex", usage="Splits the index file into multiple files, alphabetically, one file per letter, plus a file for any index entries that start with non-alphabetical symbols")
    private boolean splitIndex;
    @Option(name="-Xdoclint", metaVar="(all|none|[-]<group>)", usage="Enable or disable specific checks for problems in javadoc comments, where <group> is one of \naccessibility, html, missing, reference, or syntax.")
    private List<String> doclint;

    public Map<String, String[]> getProviderArguments() {
        if (this.providerArgumentsMap == null) {
            this.createProviderArgumentsMap();
        }
        return this.providerArgumentsMap;
    }

    private void createProviderArgumentsMap() {
        this.providerArgumentsMap = Maps.transformValues((Map)Maps.uniqueIndex(this.providerArguments, (Function)new Function<ProviderCmdLineArguments, String>(){

            public String apply(ProviderCmdLineArguments providerArgs) {
                return providerArgs.getProviderId();
            }
        }), (Function)new Function<ProviderCmdLineArguments, String[]>(){

            public String[] apply(ProviderCmdLineArguments providerArgs) {
                return providerArgs.getArguments();
            }
        });
    }

    public URL getSourcesRepository() {
        return this.sourcesRepository;
    }

    public URL getJavadocRepository() {
        return this.javadocRepository;
    }

    public List<URL> getModelsRepositories() {
        return this.modelRepositories != null ? this.modelRepositories : Collections.singletonList(Urls.toUrl((String)"http://download.eclipse.org/recommenders/models/luna/"));
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public boolean isJarOutput() {
        return this.jarOutput;
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public Artifact getCoordinate() {
        return this.coordinate;
    }

    public Artifact getModelCoordinate() {
        return this.modelCoordinate;
    }

    public String getCharset() {
        return this.charset;
    }

    public boolean isSplitIndex() {
        return this.splitIndex;
    }

    public List<String> getDoclintOptions() {
        return this.doclint != null ? this.doclint : Collections.singletonList("none");
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public boolean noDependencies() {
        return this.noDependencies;
    }

    public boolean isResume() {
        return this.resume;
    }

    public List<String> getSubpackages() {
        return this.subpackages == null ? null : Arrays.asList(this.subpackages);
    }
}

