/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.livedoc.providers.analytics;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.recommenders.livedoc.providers.AbstractLiveDocProvider;
import org.eclipse.recommenders.livedoc.providers.LiveDocProviderException;
import org.eclipse.recommenders.livedoc.providers.ProviderOutput;
import org.eclipse.recommenders.livedoc.providers.analytics.AnalyticsConfiguration;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.ProjectCoordinate;

public class AnalyticsProvider
extends AbstractLiveDocProvider<AnalyticsConfiguration> {
    private ProviderOutput providerOutput;

    public String getId() {
        return "analytics";
    }

    public void setUp(ProjectCoordinate pc, IModelRepository repo, IModelIndex index) throws LiveDocProviderException {
        super.setUp(pc, repo, index);
        this.providerOutput = this.createAnalyticsProviderOutput();
    }

    private ProviderOutput createAnalyticsProviderOutput() throws LiveDocProviderException {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("<script type=\"text/javascript\">");
            String script = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("googleanalytics.js"));
            script = script.replace("$ID$", ((AnalyticsConfiguration)this.getConfiguration()).getWebPropertyId());
            sb.append(script);
            sb.append("</script>");
            return new ProviderOutput(sb.toString(), 0);
        }
        catch (IOException iOException) {
            throw new LiveDocProviderException(String.format("Error while reading googleanalytics.js script in provider %s.", this.getId()));
        }
    }

    public ProviderOutput documentClass(ClassDoc holder) {
        return this.providerOutput;
    }

    public ProviderOutput documentPackage(PackageDoc holder) {
        return this.providerOutput;
    }

    public ProviderOutput documentOverview(RootDoc holder) {
        return this.providerOutput;
    }

    public AnalyticsConfiguration newProviderConfiguration() {
        return new AnalyticsConfiguration();
    }
}

