/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.livedoc.providers.calls;

import com.google.common.base.Optional;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.recommenders.apidocs.ClassSelfcallDirectives;
import org.eclipse.recommenders.models.IModelProvider;
import org.eclipse.recommenders.models.UniqueTypeName;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.Openable;
import org.eclipse.recommenders.utils.Zips;
import org.eclipse.recommenders.utils.gson.GsonUtil;
import org.eclipse.recommenders.utils.names.ITypeName;

public class SingleZipClassSelfCallsModelProvider
implements IModelProvider<UniqueTypeName, ClassSelfcallDirectives>,
Openable {
    private final File models;
    private ZipFile zip;

    public SingleZipClassSelfCallsModelProvider(File models) {
        this.models = models;
    }

    public void open() throws IOException {
        Zips.readFully((File)this.models);
        this.zip = new ZipFile(this.models);
    }

    public void close() throws IOException {
        Zips.closeQuietly((ZipFile)this.zip);
    }

    public Set<ITypeName> acquireableTypes() {
        return Zips.types(this.zip.entries(), (String)".json");
    }

    public Optional<ClassSelfcallDirectives> acquireModel(UniqueTypeName key) {
        InputStream is;
        String path = Zips.path((ITypeName)((ITypeName)key.getName()), (String)".json");
        ZipEntry entry = this.zip.getEntry(path);
        if (entry == null) {
            return Optional.absent();
        }
        try {
            is = this.zip.getInputStream(entry);
        }
        catch (IOException iOException) {
            return Optional.absent();
        }
        ClassSelfcallDirectives res = (ClassSelfcallDirectives)GsonUtil.deserialize((InputStream)is, ClassSelfcallDirectives.class);
        IOUtils.closeQuietly((Closeable)is);
        return Optional.of((Object)res);
    }

    public void releaseModel(ClassSelfcallDirectives value) {
    }
}

