/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.livedoc.utils;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;

public class HtmlUtils {
    public static String grey(String textToGrey) {
        return "<font color=\"#808080\">".concat(textToGrey).concat("</font>");
    }

    public static class HtmlTable {
        private String title;
        private List<String> columns = Lists.newLinkedList();
        private List<List<String>> rows = Lists.newLinkedList();
        private String htmlClass;
        private String summary;

        public HtmlTable(String title, String htmlClass, String summary) {
            this.title = title;
            this.htmlClass = htmlClass;
            this.summary = summary;
        }

        public void addColumn(String columnTitle) {
            this.columns.add(columnTitle);
        }

        public void addRow(String ... elements) {
            this.rows.add(Arrays.asList(elements));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("<table class=\"").append(this.htmlClass).append("\" border=\"0\" cellpadding=\"3\" cellspacing=\"0\" summary=\"").append(this.summary).append("\"><caption><span>").append(this.title).append("</span><span class=\"tabEnd\">&nbsp;</span></caption>");
            sb.append("<thead>").append("<tr>");
            for (String column : this.columns) {
                sb.append("<th class=\"colFirst\" scope=\"col\">").append(column).append("</th>");
            }
            sb.append("</tr>").append("</thead>").append("<tbody>");
            boolean altColor = true;
            for (List<String> columns : this.rows) {
                if (altColor) {
                    sb.append("<tr class=\"altColor\">");
                    altColor = false;
                } else {
                    sb.append("<tr class=\"rowColor\">");
                    altColor = true;
                }
                for (String element : columns) {
                    sb.append("<td class=\"colFirst\">");
                    if (columns.indexOf(element) == 0) {
                        sb.append(element);
                    } else {
                        sb.append("<div class=\"block\">").append(element).append("</div>");
                    }
                    sb.append("</td>");
                }
                sb.append("</tr>");
            }
            sb.append("</tbody>").append("</table>");
            return sb.toString();
        }
    }
}

