/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.livedoc.cli.aether;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.recommenders.livedoc.cli.aether.TransferListener;
import org.eclipse.recommenders.utils.Checks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryClient {
    private static final String REPOSITORY_LAYOUT = "default";
    private final File cacheDir;
    private final RepositorySystem repositorySystem;
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryClient.class);

    public RepositoryClient(File cacheDir) throws IOException {
        this.cacheDir = Checks.ensureIsDirectory((File)cacheDir);
        this.repositorySystem = this.createRepositorySystem();
    }

    private RepositorySystem createRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    public Artifact download(Artifact coordinate, URL repo) throws IOException {
        try {
            DefaultRepositorySystemSession session = this.newRepositorySystemSession();
            List<RemoteRepository> repos = Collections.singletonList(this.toRemoteRepository(repo));
            ArtifactRequest request = new ArtifactRequest(coordinate, repos, null);
            ArtifactResult result = this.repositorySystem.resolveArtifact((RepositorySystemSession)session, request);
            return result.getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void upload(Artifact artifact, URL repo) throws IOException {
        try {
            DefaultRepositorySystemSession session = this.newRepositorySystemSession();
            DeployRequest deployRequest = new DeployRequest();
            deployRequest.addArtifact(artifact);
            deployRequest.setRepository(this.toRemoteRepository(repo));
            this.repositorySystem.deploy((RepositorySystemSession)session, deployRequest);
        }
        catch (DeploymentException e) {
            throw new IOException(e);
        }
    }

    private DefaultRepositorySystemSession newRepositorySystemSession() {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(this.cacheDir);
        session.setLocalRepositoryManager(this.repositorySystem.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setTransferListener((org.eclipse.aether.transfer.TransferListener)new TransferListener((IProgressMonitor)new NullProgressMonitor()));
        return session;
    }

    private RemoteRepository toRemoteRepository(URL repo) {
        return new RemoteRepository.Builder("remote", REPOSITORY_LAYOUT, repo.toExternalForm()).build();
    }

    public List<Artifact> resolveDirectDependencies(Artifact sourceArtifact, URL repo) throws IOException {
        RemoteRepository remoteRepo = this.toRemoteRepository(repo);
        List<Dependency> dependencies = this.getDirectDependencies(sourceArtifact, remoteRepo);
        return this.downloadDependencies(remoteRepo, dependencies);
    }

    private List<Dependency> getDirectDependencies(Artifact sourceArtifact, RemoteRepository remoteRepo) throws IOException {
        ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
        descriptorRequest.setArtifact(sourceArtifact);
        descriptorRequest.addRepository(remoteRepo);
        DefaultRepositorySystemSession session = this.newRepositorySystemSession();
        ArtifactDescriptorResult descriptorResult = null;
        try {
            descriptorResult = this.repositorySystem.readArtifactDescriptor((RepositorySystemSession)session, descriptorRequest);
        }
        catch (ArtifactDescriptorException e) {
            throw new IOException(e);
        }
        return descriptorResult.getDependencies();
    }

    private List<Artifact> downloadDependencies(RemoteRepository remoteRepo, List<Dependency> dependencies) {
        List<RemoteRepository> repos = Collections.singletonList(remoteRepo);
        LinkedList<Artifact> artifacts = new LinkedList<Artifact>();
        DefaultRepositorySystemSession session = this.newRepositorySystemSession();
        for (Dependency dependency : dependencies) {
            ArtifactRequest request = new ArtifactRequest(dependency.getArtifact(), repos, null);
            try {
                artifacts.add(this.repositorySystem.resolveArtifact((RepositorySystemSession)session, request).getArtifact());
            }
            catch (ArtifactResolutionException e) {
                LOG.warn("Failed to resolve dependency \"{}\"\n\t{}\n", (Object)dependency.getArtifact(), (Object)e);
            }
        }
        return artifacts;
    }

    public List<Artifact> resolveTransitiveDependencies(Artifact sourceArtifact, URL repo) throws IOException {
        RemoteRepository remoteRepo = this.toRemoteRepository(repo);
        List<Dependency> dependencies = this.getTransitiveDependencies(sourceArtifact, remoteRepo);
        return this.downloadDependencies(remoteRepo, dependencies);
    }

    private List<Dependency> getTransitiveDependencies(Artifact sourceArtifact, RemoteRepository remoteRepo) throws IOException {
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency(sourceArtifact, "compile"));
        collectRequest.addRepository(remoteRepo);
        DefaultRepositorySystemSession session = this.newRepositorySystemSession();
        List dependencies = null;
        try {
            CollectResult result = this.repositorySystem.collectDependencies((RepositorySystemSession)session, collectRequest);
            PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
            result.getRoot().accept((DependencyVisitor)nlg);
            dependencies = nlg.getDependencies(true);
            if (dependencies.size() != 0) {
                dependencies.remove(0);
            }
        }
        catch (DependencyCollectionException e) {
            throw new IOException(e);
        }
        return dependencies;
    }
}

