/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models.advisors;

import com.google.common.base.Optional;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.impl.XMLResponseParser;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.eclipse.recommenders.models.Coordinates;
import org.eclipse.recommenders.models.DependencyInfo;
import org.eclipse.recommenders.models.DependencyType;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.models.advisors.AbstractProjectCoordinateAdvisor;
import org.eclipse.recommenders.utils.Fingerprints;
import org.eclipse.recommenders.utils.Urls;
import org.eclipse.recommenders.utils.Versions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenCentralFingerprintSearchAdvisor
extends AbstractProjectCoordinateAdvisor {
    public static final URL SEARCH_MAVEN_ORG = Urls.toUrl((String)"http://search.maven.org/solrsearch");
    private static final Logger LOG = LoggerFactory.getLogger(MavenCentralFingerprintSearchAdvisor.class);
    private static final int NETWORK_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(3L);
    private static final List<String> SUPPORTED_PACKAGINGS = Arrays.asList("jar", "war", "bundle");
    private static final String FIELD_GROUP_ID = "g";
    private static final String FIELD_ARTIFACT_ID = "a";
    private static final String FIELD_VERSION = "v";
    private static final String FIELD_PACKAGING = "p";
    private SolrServer server;

    public MavenCentralFingerprintSearchAdvisor() {
        this(null, -1);
    }

    public MavenCentralFingerprintSearchAdvisor(String proxyHost, int proxyPort) {
        this(proxyHost, proxyPort, null);
    }

    public MavenCentralFingerprintSearchAdvisor(String proxyHost, int proxyPort, String proxyUser) {
        this(proxyHost, proxyPort, proxyUser, null);
    }

    public MavenCentralFingerprintSearchAdvisor(String proxyHost, int proxyPort, String proxyUser, String proxyPassword) {
        this.server = this.createSolrServer(proxyHost, proxyPort, proxyUser, proxyPassword);
    }

    @Override
    protected boolean isApplicable(DependencyType dependencyType) {
        return dependencyType == DependencyType.JAR;
    }

    @Override
    protected Optional<ProjectCoordinate> doSuggest(DependencyInfo dependencyInfo) {
        try {
            SolrQuery query = new SolrQuery();
            query.setQuery("1:\"" + Fingerprints.sha1((File)dependencyInfo.getFile()) + "\"");
            query.setRows(Integer.valueOf(1));
            QueryResponse response = this.server.query((SolrParams)query);
            SolrDocumentList results = response.getResults();
            for (SolrDocument document : results) {
                if (!SUPPORTED_PACKAGINGS.contains(document.get((Object)FIELD_PACKAGING))) continue;
                String groupId = (String)document.get((Object)FIELD_GROUP_ID);
                String artifactId = (String)document.get((Object)FIELD_ARTIFACT_ID);
                String version = (String)document.get((Object)FIELD_VERSION);
                return Coordinates.tryNewProjectCoordinate(groupId, artifactId, Versions.canonicalizeVersion((String)version));
            }
            return Optional.absent();
        }
        catch (SolrServerException e) {
            LOG.error("Exception when querying Solr Server <{}>", (Object)SEARCH_MAVEN_ORG, (Object)e);
            return Optional.absent();
        }
    }

    public void setProxy(String host, int port, String user, String password) {
        this.server = this.createSolrServer(host, port, user, password);
    }

    private CommonsHttpSolrServer createSolrServer(String proxyHost, int proxyPort, String proxyUser, String proxyPassword) {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.getParams().setConnectionTimeout(NETWORK_TIMEOUT);
        connectionManager.getParams().setSoTimeout(NETWORK_TIMEOUT);
        HttpClient httpClient = new HttpClient((HttpConnectionManager)connectionManager);
        if (proxyHost != null) {
            httpClient.getHostConfiguration().setProxy(proxyHost, proxyPort);
        }
        if (proxyUser != null) {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
            httpClient.getState().setProxyCredentials(AuthScope.ANY, (Credentials)credentials);
        }
        CommonsHttpSolrServer server = new CommonsHttpSolrServer(SEARCH_MAVEN_ORG, httpClient);
        server.setAllowCompression(true);
        server.setParser((ResponseParser)new XMLResponseParser());
        return server;
    }
}

