/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.livedoc.utils;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.eclipse.recommenders.livedoc.utils.LiveDocUtils;

public class MethodDocumentationBuilder {
    private String description;
    private String title;
    private List<String> content = Lists.newArrayList();
    private List<String> listItems = Lists.newArrayList();
    private ListType listType;

    private MethodDocumentationBuilder() {
    }

    public static MethodDocumentationBuilder create() {
        return new MethodDocumentationBuilder();
    }

    public MethodDocumentationBuilder title(String title) {
        this.title = title;
        return this;
    }

    public MethodDocumentationBuilder description(String description) {
        this.description = description;
        return this;
    }

    public MethodDocumentationBuilder paragraph(String paragraph) {
        this.content.add(paragraph);
        return this;
    }

    public MethodDocumentationBuilder beginList(ListType listType) {
        this.listItems = Lists.newArrayList();
        this.listType = listType;
        return this;
    }

    public MethodDocumentationBuilder addItem(String item) {
        this.listItems.add(item);
        return this;
    }

    public MethodDocumentationBuilder endList() {
        switch (this.listType) {
            case SEQUENTIAL: {
                this.content.add(this.createSequentialList());
                break;
            }
            case BULLETS: {
                this.content.add(this.createBulletList());
            }
        }
        return this;
    }

    private String createSequentialList() {
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = this.listItems.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private String createBulletList() {
        StringBuilder sb = new StringBuilder();
        sb.append("<ul>");
        Iterator<String> it = this.listItems.iterator();
        while (it.hasNext()) {
            sb.append("<li>");
            sb.append(it.next());
            if (it.hasNext()) {
                sb.append(",");
            }
            sb.append("</li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    public String build() {
        StringBuilder sb = new StringBuilder();
        sb.append(LiveDocUtils.surroundWith("<dt>", this.createTitle(), "</dt>"));
        sb.append(LiveDocUtils.surroundWith("<dd>", String.valueOf(this.createDescription()) + this.createContent(), "</dd>"));
        return sb.toString();
    }

    private String createTitle() {
        if (this.isNullOrEmpty(this.title)) {
            return "";
        }
        return LiveDocUtils.surroundWith("<span class=\"strong\">", this.title, "</span>");
    }

    private boolean isNullOrEmpty(String string) {
        return string == null || "".equals(string);
    }

    private String createDescription() {
        if (this.isNullOrEmpty(this.description)) {
            return "";
        }
        return String.valueOf(this.description) + "<br>" + "<br>";
    }

    private String createContent() {
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = this.content.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append("<br>");
        }
        return sb.toString();
    }

    public static enum ListType {
        SEQUENTIAL,
        BULLETS;

    }
}

