/**
 * Copyright (c) 2014 Patrick Gottschaemmer.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick Gottschaemmer - initial API and implementation.
 */
package org.eclipse.recommenders.livedoc.cli.logback.converters;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;

public class ExceptionMessageConverter extends ClassicConverter {

    @Override
    public String convert(ILoggingEvent event) {

        IThrowableProxy throwable = event.getThrowableProxy();

        // Not an Exception to convert?
        if (throwable == null) {
            return "";
        }

        StringBuilder sb = new StringBuilder();

        if (messageNotNull(throwable)) {
            sb.append("\t");
            sb.append("Message: ");
            sb.append(throwable.getMessage());
            sb.append(String.format("%n"));
        }

        sb.append("\t");
        sb.append("Exception: ");
        sb.append(throwable.getClassName());
        sb.append(String.format("%n"));

        return sb.toString();
    }

    private boolean messageNotNull(IThrowableProxy throwable) {
        return throwable.getMessage() != null;
    }

}
