/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.livedoc.cli.aether;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;
import org.eclipse.core.runtime.IProgressMonitor;

public class TransferListener
extends AbstractTransferListener {
    private final IProgressMonitor monitor;
    private Map<TransferResource, Long> downloads = new ConcurrentHashMap<TransferResource, Long>();

    public TransferListener(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void transferInitiated(TransferEvent event) {
        String mode = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading" : "Downloading";
        String resourceName = String.valueOf(event.getResource().getRepositoryUrl()) + event.getResource().getResourceName();
        this.monitor.subTask(String.format("%s: %s", mode, resourceName));
    }

    public void transferStarted(TransferEvent event) {
    }

    public void transferProgressed(TransferEvent event) {
        TransferResource resource = event.getResource();
        this.downloads.put(resource, event.getTransferredBytes());
        for (Map.Entry<TransferResource, Long> entry : this.downloads.entrySet()) {
            long total = entry.getKey().getContentLength();
            long complete = entry.getValue();
            this.monitor.subTask(this.getStatus(complete, total));
        }
    }

    public void transferSucceeded(TransferEvent event) {
        TransferResource resource = event.getResource();
        this.downloads.remove(resource);
        this.monitor.subTask("Finished transfer: " + resource.getResourceName());
    }

    private String getStatus(long complete, long total) {
        if (total >= 1024L) {
            return String.valueOf(this.toKB(complete)) + "/" + this.toKB(total) + " KB ";
        }
        if (total >= 0L) {
            return String.valueOf(complete) + "/" + total + " B ";
        }
        if (complete >= 1024L) {
            return String.valueOf(this.toKB(complete)) + " KB ";
        }
        return String.valueOf(complete) + " B ";
    }

    public void transferFailed(TransferEvent event) {
        this.monitor.subTask("Transfer failed: " + event.getException().getLocalizedMessage());
    }

    public void transferCorrupted(TransferEvent event) {
        this.monitor.subTask("Transfer corrupted: " + event.getException().getLocalizedMessage());
    }

    private long toKB(long bytes) {
        return (bytes + 1023L) / 1024L;
    }
}

