/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.livedoc.providers.overrides;

import com.google.common.base.Optional;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.recommenders.apidocs.ClassOverridePatterns;
import org.eclipse.recommenders.apidocs.MethodPattern;
import org.eclipse.recommenders.apidocs.SingleZipOverridePatternsModelProvider;
import org.eclipse.recommenders.livedoc.providers.AbstractLiveDocProvider;
import org.eclipse.recommenders.livedoc.providers.LiveDocProviderException;
import org.eclipse.recommenders.livedoc.providers.ProviderOutput;
import org.eclipse.recommenders.livedoc.providers.overrides.MethodOverridePatternsConfiguration;
import org.eclipse.recommenders.livedoc.utils.LiveDocUtils;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.IModelProvider;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.models.UniqueTypeName;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;

public class MethodOverridePatternsProvider
extends AbstractLiveDocProvider<MethodOverridePatternsConfiguration> {
    private IModelProvider<IUniqueName<ITypeName>, ClassOverridePatterns> modelProvider;
    private Optional<ClassOverridePatterns> model;

    public String getId() {
        return "ovrp";
    }

    public void setUp(ProjectCoordinate pc, IModelRepository repo, IModelIndex index) throws LiveDocProviderException {
        super.setUp(pc, repo, index);
        Optional modelArchive = this.fetchModelArchive("ovrp");
        if (!modelArchive.isPresent()) {
            throw new LiveDocProviderException(String.format("No %s model available for given coordinate.", this.getId()));
        }
        this.modelProvider = new SingleZipOverridePatternsModelProvider((File)modelArchive.get());
        try {
            this.modelProvider.open();
        }
        catch (IOException e) {
            throw new LiveDocProviderException(String.format("Exception while opening model provider for %s models.", this.getId()), (Throwable)e);
        }
    }

    public void beginClass(ClassDoc newClassDoc) {
        ITypeName typeName = LiveDocUtils.extractTypeName((Doc)newClassDoc);
        UniqueTypeName uniqueTypeName = new UniqueTypeName(this.getProjectCoordinate(), typeName);
        this.model = this.modelProvider.acquireModel((IUniqueName)uniqueTypeName);
    }

    public void endClass(ClassDoc oldClassDoc) {
        if (this.model.isPresent()) {
            this.modelProvider.releaseModel((Object)((ClassOverridePatterns)this.model.get()));
        }
    }

    public ProviderOutput documentClass(ClassDoc holder) {
        if (!this.model.isPresent()) {
            return null;
        }
        MethodPattern[] methodPatterns = ((ClassOverridePatterns)this.model.get()).getPatterns();
        List patterns = Arrays.stream(methodPatterns).filter(this.oneElementPatterns()).filter(this.relevantPatterns()).sorted(this.methodPatternComparator()).limit(((MethodOverridePatternsConfiguration)this.getConfiguration()).getNumberThreshold()).collect(Collectors.toList());
        if (patterns.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<h5>Method override patterns:</h5>").append("The following groups of methods are frequently overridden together:").append("<br>").append("<br>").append("<ul>");
        int i = 0;
        while (i < patterns.size()) {
            MethodPattern pattern = (MethodPattern)patterns.get(i);
            sb.append("<li>");
            sb.append("<b>");
            sb.append("Pattern #" + (i + 1));
            sb.append(", ");
            sb.append("</b>");
            sb.append(String.valueOf(pattern.getNumberOfObservations()) + " times observed");
            sb.append("<br>").append("<br>");
            ArrayList<Map.Entry<IMethodName, Double>> methods = new ArrayList<Map.Entry<IMethodName, Double>>(pattern.getMethods().entrySet());
            this.sortMethods(methods);
            Iterator iterator = methods.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (!((Double)entry.getValue() >= 0.7) && methods.indexOf(entry) >= 3) continue;
                sb.append("<code>");
                sb.append((CharSequence)LiveDocUtils.strong((StringBuilder)LiveDocUtils.htmlLink((IMethodName)((IMethodName)entry.getKey())))).append(LiveDocUtils.listParameterTypes((IMethodName)((IMethodName)entry.getKey())));
                sb.append("</code>");
                sb.append(" - ").append("<font color=\"#0000FF\">").append(String.valueOf(this.asPercentage(entry)) + "%").append("</font>");
                if (!iterator.hasNext()) continue;
                sb.append("<br>");
            }
            if (i < methodPatterns.length - 1) {
                sb.append("<br>").append("<br>");
            }
            sb.append("</li>");
            ++i;
        }
        sb.append("</ul>");
        this.highlight(sb);
        return new ProviderOutput(sb.toString(), patterns.size());
    }

    private Predicate<? super MethodPattern> relevantPatterns() {
        return pattern -> pattern.getNumberOfObservations() >= ((MethodOverridePatternsConfiguration)this.getConfiguration()).getTimesObservedThreshold();
    }

    private Predicate<? super MethodPattern> oneElementPatterns() {
        return pattern -> pattern.getMethods().keySet().size() > 1;
    }

    private Comparator<MethodPattern> methodPatternComparator() {
        return (p1, p2) -> p2.getNumberOfObservations() - p1.getNumberOfObservations();
    }

    private void sortMethods(List<Map.Entry<IMethodName, Double>> methods) {
        Collections.sort(methods, new Comparator<Map.Entry<IMethodName, Double>>(){

            @Override
            public int compare(Map.Entry<IMethodName, Double> o1, Map.Entry<IMethodName, Double> o2) {
                if (!o1.getValue().equals(o2.getValue())) {
                    return o2.getValue().compareTo(o1.getValue());
                }
                return o1.getKey().getName().compareTo(o2.getKey().getName());
            }
        });
    }

    private int asPercentage(Map.Entry<IMethodName, Double> entry) {
        Double rel = entry.getValue();
        Checks.ensureIsInRange((double)rel, (double)0.0, (double)1.0, (String)"relevance '%f' not in interval [0, 1]", (Object[])new Object[]{rel});
        return (int)Math.round(rel * 100.0);
    }

    public void tearDown() throws LiveDocProviderException {
        if (this.modelProvider != null) {
            try {
                this.modelProvider.close();
            }
            catch (IOException e) {
                throw new LiveDocProviderException(String.format("Exception while closing model provider for %s models.", this.getId()), (Throwable)e);
            }
        }
    }

    public MethodOverridePatternsConfiguration newProviderConfiguration() {
        return new MethodOverridePatternsConfiguration();
    }
}

