/**
 * Copyright (c) 2014 Patrick Gottschaemmer.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.recommenders.internal.livedoc;

import java.util.List;
import java.util.Map;

import org.eclipse.recommenders.livedoc.providers.ILivedocProvider;
import org.eclipse.recommenders.utils.Nullable;

public interface IProviderManager {

    /**
     * @param providerArguments
     *            empty or null --> no Provider Arguments
     * @return the loaded Providers, will always force a reload if Providers are already loaded.
     */
    List<ILivedocProvider<?>> loadProviders(@Nullable Map<String, String[]> providerArguments);

    /**
     * 
     * @return the current loaded Providers. Null if Providers haven't been loaded yet.
     */
    @Nullable
    List<ILivedocProvider<?>> getProviders();

    /**
     * 
     * @return get the ids of current loaded Providers. Null if Providers haven't been loaded yet.
     */
    @Nullable
    List<String> getProviderIds();

}
