/**
 * Copyright (c) 2014 Patrick Gottschaemmer.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.recommenders.livedoc;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Map;

import org.eclipse.recommenders.livedoc.providers.ProviderConfiguration;
import org.eclipse.recommenders.livedoc.utils.LivedocPreconditionException;

public interface ILivedoc {

    boolean generate() throws LivedocPreconditionException;

    void setVerbose(boolean verbose);

    void setOutputDir(File dir);

    void setSourceDir(File sourcePath);

    void setGroupId(String groupId);

    void setArtifactId(String artifactId);

    void setArtifactVersion(String version);

    void setModelRepositories(List<URL> modelRepositories);

    void setEncoding(String charset);

    void setHighlight(boolean highlight);

    void setSubpackages(List<String> subpackages);

    void addAdditonalClasspathEntry(File entry);

    void setSplitIndex(boolean splitIndex);

    void setProviderArguments(Map<String, String[]> providerArguments);

    void setDoclintOptions(List<String> doclintOptions);
}
