/**
 * Copyright (c) 2013 Patrick Gottschaemmer.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick Gottschaemmer - initial API and implementation.
 */
package org.eclipse.recommenders.livedoc.providers;

public class ProviderOutput {

    private String htmlCode;
    private int numberOfRecommendations;

    // TODO: some additional statistic fields

    /**
     * @param htmlCode
     *            the HTML Code to display
     * @param numberOfRecommendations
     *            number of Recommendations on the highest possible level, which makes sense.<br>
     *            (e.g., for ovrp, this would be the number of patterns, NOT the number of methods inside patterns) <br>
     *            This number will be used in the package level aggregations (ovrp = ## Recommendations for Type XY)
     */
    public ProviderOutput(String htmlCode, int numberOfRecommendations) {
        this.htmlCode = htmlCode;
        this.numberOfRecommendations = numberOfRecommendations;
    }

    public String getHtmlCode() {
        return htmlCode;
    }

    public int getNumberOfRecommendations() {
        return numberOfRecommendations;
    }
}
