/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.livedoc.javadoc;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.ModelCoordinate;
import org.eclipse.recommenders.models.ProjectCoordinate;

public class CompositeModelIndex
implements IModelIndex {
    private final List<IModelIndex> componentIndexes;

    public CompositeModelIndex(Iterable<IModelIndex> componentIndexes) {
        this.componentIndexes = Lists.newArrayList(componentIndexes);
    }

    public void open() throws IOException {
        for (IModelIndex componentIndex : this.componentIndexes) {
            componentIndex.open();
        }
    }

    public void close() throws IOException {
        for (IModelIndex componentIndex : this.componentIndexes) {
            componentIndex.close();
        }
    }

    public ImmutableSet<ModelCoordinate> getKnownModels(String modelType) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (IModelIndex componentIndex : this.componentIndexes) {
            builder.addAll((Iterable)componentIndex.getKnownModels(modelType));
        }
        return builder.build();
    }

    public Optional<ModelCoordinate> suggest(ProjectCoordinate pc, String modelType) {
        for (IModelIndex componentIndex : this.componentIndexes) {
            Optional suggestion = componentIndex.suggest(pc, modelType);
            if (!suggestion.isPresent()) continue;
            return suggestion;
        }
        return Optional.absent();
    }

    public ImmutableSet<ModelCoordinate> suggestCandidates(ProjectCoordinate pc, String modelType) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (IModelIndex componentIndex : this.componentIndexes) {
            builder.addAll((Iterable)componentIndex.suggestCandidates(pc, modelType));
        }
        return builder.build();
    }

    public Optional<ProjectCoordinate> suggestProjectCoordinateByArtifactId(String artifactId) {
        for (IModelIndex componentIndex : this.componentIndexes) {
            Optional suggestion = componentIndex.suggestProjectCoordinateByArtifactId(artifactId);
            if (!suggestion.isPresent()) continue;
            return suggestion;
        }
        return Optional.absent();
    }

    public Optional<ProjectCoordinate> suggestProjectCoordinateByFingerprint(String fingerprint) {
        for (IModelIndex componentIndex : this.componentIndexes) {
            Optional suggestion = componentIndex.suggestProjectCoordinateByFingerprint(fingerprint);
            if (!suggestion.isPresent()) continue;
            return suggestion;
        }
        return Optional.absent();
    }

    public void updateIndex(File index) throws IOException {
        for (IModelIndex componentIndex : this.componentIndexes) {
            componentIndex.updateIndex(index);
        }
    }
}

