/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models.advisors;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.recommenders.models.DependencyInfo;
import org.eclipse.recommenders.models.DependencyType;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.models.advisors.AbstractProjectCoordinateAdvisor;

public class JREExecutionEnvironmentAdvisor
extends AbstractProjectCoordinateAdvisor {
    private static final String GROUP_ID = "jre";
    private static final String ARTIFACT_ID = "jre";
    private static Map<String, ProjectCoordinate> lookUpTable = JREExecutionEnvironmentAdvisor.createLookUpTable();

    @Override
    protected Optional<ProjectCoordinate> doSuggest(DependencyInfo dependencyInfo) {
        String optionalExecutionEnvironment = (String)dependencyInfo.getHint("EXECUTION_ENVIRONMENT").orNull();
        if (optionalExecutionEnvironment != null) {
            ProjectCoordinate pc = lookUpTable.get(optionalExecutionEnvironment);
            return Optional.fromNullable((Object)pc);
        }
        return Optional.absent();
    }

    private static Map<String, ProjectCoordinate> createLookUpTable() {
        HashMap result = Maps.newHashMap();
        result.put("JRE-1.1", new ProjectCoordinate("jre", "jre", "1.1.0"));
        result.put("J2SE-1.2", new ProjectCoordinate("jre", "jre", "1.2.0"));
        result.put("J2SE-1.3", new ProjectCoordinate("jre", "jre", "1.3.0"));
        result.put("J2SE-1.4", new ProjectCoordinate("jre", "jre", "1.4.0"));
        result.put("J2SE-1.5", new ProjectCoordinate("jre", "jre", "1.5.0"));
        result.put("JavaSE-1.6", new ProjectCoordinate("jre", "jre", "1.6.0"));
        result.put("JavaSE-1.7", new ProjectCoordinate("jre", "jre", "1.7.0"));
        result.put("JavaSE-1.8", new ProjectCoordinate("jre", "jre", "1.8.0"));
        return result;
    }

    @Override
    public boolean isApplicable(DependencyType dependencyType) {
        return dependencyType == DependencyType.JRE;
    }
}

