/**
 * Copyright (c) 2014 Patrick Gottschaemmer.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.recommenders.livedoc.providers.overrides;

import org.eclipse.recommenders.livedoc.providers.ProviderConfiguration;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.IntOptionHandler;

public class MethodOverridePatternsConfiguration extends ProviderConfiguration {

    @Option(name = "-top", handler = IntOptionHandler.class)
    private int topNumbers = Integer.MAX_VALUE;

    @Option(name = "-times")
    private int times = 0;

    public int getTimesObservedThreshold() {
        return times;
    }

    public int getNumberThreshold() {
        return topNumbers;
    }

}
