/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.logging.ext;

import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.filter.Filter;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.recommenders.logging.ext.BugzillaDialog;
import org.eclipse.recommenders.logging.ext.BugzillaFilter;
import org.eclipse.recommenders.logging.ext.BugzillaHelper;
import org.eclipse.recommenders.logging.ext.BugzillaParam;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class BugzillaAppender
extends AppenderBase<LoggingEvent> {
    private static final long FIVE_MIN = 5L;
    private long lastReportTS = 0L;
    private long interval = 2L;
    private boolean ignoreAll = false;
    private BugzillaParam bugParam;
    private Set<BugzillaEvent> logEvents = new HashSet<BugzillaEvent>();

    public long getTimePeriod() {
        return this.interval;
    }

    public void setTimePeriod(long timePeriod) {
        this.interval = timePeriod;
    }

    public BugzillaParam getBugParam() {
        return this.bugParam;
    }

    public void setBugParam(BugzillaParam keyword) {
        this.bugParam = keyword;
    }

    public void addFilter(Filter<LoggingEvent> newFilter) {
        if (this.getCopyOfAttachedFiltersList().isEmpty() && newFilter instanceof BugzillaFilter) {
            super.addFilter(newFilter);
        }
    }

    protected void append(LoggingEvent eventObject) {
        if (!this.ignoreAll) {
            this.logEvents.add(new BugzillaEvent(eventObject));
            if (!this.withinTimeFrame()) {
                this.showUserConsentDialog();
            }
        }
    }

    private boolean withinTimeFrame() {
        if (this.lastReportTS != 0L && System.currentTimeMillis() - this.lastReportTS <= TimeUnit.MINUTES.toMillis(this.interval)) {
            return true;
        }
        this.lastReportTS = System.currentTimeMillis();
        return false;
    }

    private void showUserConsentDialog() {
        BugzillaUIJob job = new BugzillaUIJob(BugzillaAppender.class.getName(), "I have identified " + this.logEvents.size() + " error(s) with keyword \"" + this.bugParam.getKey() + "\". Would you like to report these error(s)?");
        job.addJobChangeListener((IJobChangeListener)new BugzillaJobChangeAdapter(this.logEvents));
        this.logEvents.clear();
        job.schedule();
    }

    private class BugzillaEvent {
        private LoggingEvent event;

        public BugzillaEvent(LoggingEvent event) {
            this.event = event;
        }

        public LoggingEvent getEvent() {
            return this.event;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + (this.event == null ? 0 : this.event.getMessage().hashCode());
            result = 31 * result + (this.event == null ? 0 : BugzillaHelper.getStackTrace(this.event).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            BugzillaEvent other = (BugzillaEvent)obj;
            return other.event.getMessage().equals(this.event.getMessage()) && BugzillaHelper.getStackTrace(this.event).equals(BugzillaHelper.getStackTrace(other.event));
        }

        private BugzillaAppender getOuterType() {
            return BugzillaAppender.this;
        }
    }

    private class BugzillaJobChangeAdapter
    extends JobChangeAdapter {
        private Set<BugzillaEvent> events = new HashSet<BugzillaEvent>();

        public BugzillaJobChangeAdapter(Set<BugzillaEvent> events) {
            this.events.addAll(events);
        }

        public void done(IJobChangeEvent jobEvent) {
            if (jobEvent.getResult().isOK()) {
                new Job("adafs"){

                    protected IStatus run(IProgressMonitor monitor) {
                        for (BugzillaEvent event : BugzillaJobChangeAdapter.this.events) {
                            BugzillaHelper.createBug(event.getEvent(), BugzillaAppender.this.bugParam);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            } else {
                this.events.clear();
            }
        }
    }

    private class BugzillaUIJob
    extends UIJob {
        private String msg;

        public BugzillaUIJob(String name, String msg) {
            super(name);
            this.msg = msg;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            if (window != null) {
                Shell parent = window.getShell();
                parent.forceActive();
                BugzillaDialog consentDialog = BugzillaDialog.openNotification(parent, "Recommenders Logging", this.msg, "Ignore all such exceptions.", false, null, null, TimeUnit.MINUTES.toMillis(1L));
                BugzillaAppender.this.ignoreAll = consentDialog.getToggleState();
                if (consentDialog.getReturnCode() == 2) {
                    return Status.OK_STATUS;
                }
            }
            return Status.CANCEL_STATUS;
        }
    }
}

