/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.logging.ext;

import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import java.awt.Desktop;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.recommenders.logging.ext.BugzillaAppender;
import org.eclipse.recommenders.logging.ext.BugzillaParam;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

public class BugzillaHelper {
    public static String getQueryString(Map<String, String> paramMap) {
        StringBuilder builder = new StringBuilder();
        for (String param : paramMap.keySet()) {
            builder.append(param);
            builder.append("=");
            builder.append(paramMap.get(param));
            builder.append("&");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public static String getStackTrace(LoggingEvent event) {
        StringWriter sw = new StringWriter();
        ThrowableProxy tp = (ThrowableProxy)event.getThrowableProxy();
        if (tp != null) {
            Throwable t = tp.getThrowable();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            return sw.toString();
        }
        sw.append(event.getFormattedMessage());
        return sw.toString();
    }

    public static URI createBugzillaUri(LoggingEvent event, BugzillaParam param) throws URISyntaxException, MalformedURLException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("product", param.getProduct());
        paramMap.put("version", param.getVersion());
        paramMap.put("bug_severity", "critical");
        paramMap.put("short_desc", event.getMessage());
        paramMap.put("comment", BugzillaHelper.getStackTrace(event));
        paramMap.put("component", param.getComponent());
        paramMap.put("rep_platform", "All");
        paramMap.put("op_sys", System.getProperty("os.name"));
        URL url = new URL(param.getUrl());
        return new URI(url.getProtocol(), url.getAuthority(), url.getPath(), BugzillaHelper.getQueryString(paramMap), null);
    }

    public static void createBug(LoggingEvent event, BugzillaParam param) {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(BugzillaHelper.createBugzillaUri(event, param));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(BugzillaAppender.class.getName());
                browser.openURL(BugzillaHelper.createBugzillaUri(event, param).toURL());
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }
}

