/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.logging.ext;

import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.AppenderBase;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class EclipseLogAppender
extends AppenderBase<LoggingEvent> {
    private ILog log;

    protected void append(LoggingEvent event) {
        if (this.log == null) {
            Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
            this.log = Platform.getLog((Bundle)bundle);
        }
        String pluginId = event.getLoggerName();
        Status status = new Status(this.getSeverity(event), pluginId, event.getMessage(), this.getThrowable(event));
        this.log.log((IStatus)status);
    }

    private int getSeverity(LoggingEvent event) {
        switch (event.getLevel().levelInt) {
            case 40000: {
                return 4;
            }
            case 20000: {
                return 1;
            }
            case 30000: {
                return 2;
            }
        }
        return 0;
    }

    private Throwable getThrowable(LoggingEvent event) {
        Throwable t = null;
        if (event.hasCallerData()) {
            t = new Throwable();
            t.setStackTrace(event.getCallerData());
        }
        return t;
    }
}

