/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import java.io.File;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.equinox.log.ExtendedLogService;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class LogbackService {
    private static final String LOGBACK_CONFIG_FILE = "logback.xml";
    private ExtendedLogService log;

    public void bindLogService(ExtendedLogService log) {
        this.log = log;
    }

    public void activate() throws Exception {
        try {
            LoggerContext logContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            Bundle bundle = FrameworkUtil.getBundle(this.getClass());
            URL configUrl = bundle.getEntry(LOGBACK_CONFIG_FILE);
            URI configUri = FileLocator.resolve((URL)configUrl).toURI();
            File configFile = new File(configUri);
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)logContext);
            logContext.reset();
            configurator.doConfigure(configFile);
        }
        catch (Exception e) {
            this.log.log(1, "Failed to configure logback logging system", (Throwable)e);
        }
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    public void deactivate() throws Exception {
        SLF4JBridgeHandler.uninstall();
    }
}

