/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.privacy.example.rcp.dialogs;

import java.io.IOException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.recommenders.internal.privacy.example.rcp.dialogs.HeartbeatInterval;
import org.eclipse.recommenders.internal.privacy.example.rcp.l10n.Messages;
import org.eclipse.recommenders.privacy.rcp.IConfigurationDialogFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatConfigurationFactory
implements IConfigurationDialogFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HeartbeatConfigurationFactory.class);

    public void open(Shell shell) {
        ConfigurationDialog configurationDialog = new ConfigurationDialog(shell);
        configurationDialog.open();
    }

    private class ConfigurationDialog
    extends TrayDialog {
        private ComboViewer comboViewer;
        private HeartbeatInterval heartbeatDelay;
        private ScopedPreferenceStore prefStore;

        protected ConfigurationDialog(Shell parentShell) {
            super(parentShell);
            IEclipsePreferences rootNode = InstanceScope.INSTANCE.getNode("org.eclipse.recommenders.privacy.example.rcp");
            this.prefStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, rootNode.node("advanced").absolutePath());
            this.setHelpAvailable(false);
            this.setShellStyle(this.getShellStyle() | 0x10000000);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.createDescriptionLabel(composite);
            this.createSelectionLabel(composite);
            Dialog.applyDialogFont((Control)parent);
            return composite;
        }

        private void createDescriptionLabel(Composite parent) {
            Label label = new Label(parent, 64);
            GridDataFactory.fillDefaults().hint(300, -1).applyTo((Control)label);
            label.setText(Messages.CONFIGURATION_DIALOG_DESCRIPTION);
        }

        private void createSelectionLabel(Composite parent) {
            this.comboViewer = new ComboViewer(parent, 8);
            GridDataFactory.fillDefaults().grab(true, false).hint(300, -1).applyTo(this.comboViewer.getControl());
            this.comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    HeartbeatInterval delay = (HeartbeatInterval)((Object)element);
                    return delay.toString();
                }
            });
            this.comboViewer.setInput((Object)HeartbeatInterval.values());
            this.setComboSelection();
        }

        private void setComboSelection() {
            HeartbeatInterval delay;
            String selection = this.prefStore.getString("delay");
            try {
                delay = HeartbeatInterval.valueOf(selection);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                delay = HeartbeatInterval.HOURLY;
            }
            this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)delay));
        }

        protected void okPressed() {
            this.persistComboSelection();
            super.okPressed();
        }

        private void persistComboSelection() {
            StructuredSelection selection = (StructuredSelection)this.comboViewer.getSelection();
            this.heartbeatDelay = (HeartbeatInterval)((Object)selection.getFirstElement());
            this.prefStore.setValue("delay", this.heartbeatDelay.name());
            try {
                this.prefStore.save();
            }
            catch (IOException e) {
                LOG.error("Failed to flush preferences", (Throwable)e);
            }
        }

        protected boolean isResizable() {
            return true;
        }
    }
}

