/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.privacy.rcp.data;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.recommenders.internal.privacy.rcp.data.ApprovalType;
import org.eclipse.recommenders.internal.privacy.rcp.data.DatumCategory;
import org.eclipse.recommenders.internal.privacy.rcp.data.Principal;
import org.eclipse.recommenders.internal.privacy.rcp.data.PrincipalCategory;
import org.eclipse.recommenders.internal.privacy.rcp.data.PrivateDatum;
import org.eclipse.recommenders.internal.privacy.rcp.data.PrivatePermission;
import org.eclipse.recommenders.privacy.rcp.IConfigurationDialogFactory;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionReader {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionReader.class);
    private static final String DATUM_EXTENSION_POINT_ID = "org.eclipse.recommenders.privacy.rcp.datums";
    private static final String DATUM_ELEMENT = "datum";
    private static final String DATUM_ID_ATTRIBUTE = "datumId";
    private static final String PRINCIPAL_EXTENSION_POINT_ID = "org.eclipse.recommenders.privacy.rcp.principals";
    private static final String PRINCIPAL_ELEMENT = "principal";
    private static final String PRINCIPAL_ID_ATTRIBUTE = "principalId";
    private static final String PERMISSION_EXTENSION_POINT_ID = "org.eclipse.recommenders.privacy.rcp.permissions";
    private static final String PERMISSION_ELEMENT = "permission";
    private static final String ID_ATTRIBUTE = "id";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String ICON_ATTRIBUTE = "icon";
    private static final String PURPOSE_ATTRIBUTE = "purpose";
    private static final String POLICY_URI_ATTRIBUTE = "policyUri";
    private static final String APPROVAL_TYPE_ATTRIBUTE = "askForApproval";
    private static final String SUGGEST_APPROVAL_ATTRIBUTE = "suggestApproval";
    private static final String CONFIGURATION_DIALOG_ATTRIBUTE = "configurationDialogFactory";
    private Map<String, PrivateDatum> privateDatumMap;
    private Map<String, Principal> principalMap;
    private Map<String, DatumCategory> datumCategoryMap;
    private Map<String, PrincipalCategory> principalCategoryMap;
    private Set<DatumCategory> datumCategorySet;
    private Set<PrincipalCategory> princiaplCategorySet;
    private Map<PrivatePermission, IConfigurationElement> advancedConfigMap;

    public ExtensionReader() {
        this.readRegisteredExtensions();
    }

    private void readRegisteredExtensions() {
        this.readRegisteredDatums();
        this.readRegisteredPrincipals();
        this.readRegisteredPermissions();
    }

    private void readRegisteredDatums() {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(DATUM_EXTENSION_POINT_ID);
        this.readRegisteredDatums(configurationElements);
    }

    @VisibleForTesting
    void readRegisteredDatums(IConfigurationElement ... configurationElements) {
        this.privateDatumMap = new HashMap<String, PrivateDatum>();
        HashMap<String, PrivateDatum> privateDatumMap = this.privateDatumMap;
        this.datumCategoryMap = new HashMap<String, DatumCategory>();
        HashMap<String, DatumCategory> datumCategoryMap = this.datumCategoryMap;
        this.datumCategorySet = new HashSet<DatumCategory>();
        HashSet<DatumCategory> datumCategorySet = this.datumCategorySet;
        if (configurationElements == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            if (DATUM_ELEMENT.equals(configurationElement.getName())) {
                String pluginId = configurationElement.getContributor().getName();
                String datumId = configurationElement.getAttribute(ID_ATTRIBUTE);
                String datumName = configurationElement.getAttribute(NAME_ATTRIBUTE);
                String datumDescription = configurationElement.getAttribute(DESCRIPTION_ATTRIBUTE);
                String icon = configurationElement.getAttribute(ICON_ATTRIBUTE);
                ImageDescriptor imageDescriptor = this.getImageDescriptor(pluginId, icon, "icons/obj16/defaultDatum.gif");
                if (this.isValidAttribute(datumId) && this.isValidAttribute(datumName) && this.isValidAttribute(datumDescription)) {
                    PrivateDatum datum = new PrivateDatum(datumId, datumName, datumDescription, imageDescriptor);
                    privateDatumMap.put(datumId, datum);
                    DatumCategory datumCategory = new DatumCategory(datum);
                    datumCategorySet.add(datumCategory);
                    datumCategoryMap.put(datumId, datumCategory);
                } else {
                    LOG.error("Failed to read private datum, invalid or missing attribute");
                }
            }
            ++n2;
        }
        this.privateDatumMap = privateDatumMap;
        this.datumCategoryMap = datumCategoryMap;
        this.datumCategorySet = datumCategorySet;
    }

    private void readRegisteredPrincipals() {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(PRINCIPAL_EXTENSION_POINT_ID);
        this.readRegisteredPrincipals(configurationElements);
    }

    @VisibleForTesting
    void readRegisteredPrincipals(IConfigurationElement ... configurationElements) {
        this.principalMap = new HashMap<String, Principal>();
        HashMap<String, Principal> principalMap = this.principalMap;
        this.principalCategoryMap = new HashMap<String, PrincipalCategory>();
        HashMap<String, PrincipalCategory> principalCategoryMap = this.principalCategoryMap;
        this.princiaplCategorySet = new HashSet<PrincipalCategory>();
        HashSet<PrincipalCategory> princiaplCategorySet = this.princiaplCategorySet;
        if (configurationElements == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            if (PRINCIPAL_ELEMENT.equals(configurationElement.getName())) {
                String pluginId = configurationElement.getContributor().getName();
                String principalId = configurationElement.getAttribute(ID_ATTRIBUTE);
                String principalName = configurationElement.getAttribute(NAME_ATTRIBUTE);
                String principalDescription = configurationElement.getAttribute(DESCRIPTION_ATTRIBUTE);
                String icon = configurationElement.getAttribute(ICON_ATTRIBUTE);
                ImageDescriptor imageDescriptor = this.getImageDescriptor(pluginId, icon, "icons/obj16/defaultPrincipal.gif");
                if (this.isValidAttribute(principalId) && this.isValidAttribute(principalName) && this.isValidAttribute(principalDescription)) {
                    Principal principal = new Principal(principalId, principalName, principalDescription, imageDescriptor);
                    principalMap.put(principalId, principal);
                    PrincipalCategory principalCategory = new PrincipalCategory(principal);
                    princiaplCategorySet.add(principalCategory);
                    principalCategoryMap.put(principalId, principalCategory);
                } else {
                    LOG.error("Failed to read principal, invalid or missing attribute");
                }
            }
            ++n2;
        }
        this.principalMap = principalMap;
        this.principalCategoryMap = principalCategoryMap;
        this.princiaplCategorySet = princiaplCategorySet;
    }

    private void readRegisteredPermissions() {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(PERMISSION_EXTENSION_POINT_ID);
        this.readRegisteredPermissions(configurationElements);
    }

    @VisibleForTesting
    void readRegisteredPermissions(IConfigurationElement ... configurationElements) {
        this.advancedConfigMap = new HashMap<PrivatePermission, IConfigurationElement>();
        HashMap<PrivatePermission, IConfigurationElement> advancedConfigMap = this.advancedConfigMap;
        if (configurationElements == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            if (PERMISSION_ELEMENT.equals(configurationElement.getName())) {
                String datumId = configurationElement.getAttribute(DATUM_ID_ATTRIBUTE);
                String principalId = configurationElement.getAttribute(PRINCIPAL_ID_ATTRIBUTE);
                String purpose = configurationElement.getAttribute(PURPOSE_ATTRIBUTE);
                String policy = configurationElement.getAttribute(POLICY_URI_ATTRIBUTE);
                ApprovalType approvalType = this.toApprovalType(configurationElement.getAttribute(APPROVAL_TYPE_ATTRIBUTE));
                boolean suggestApproval = Boolean.parseBoolean(configurationElement.getAttribute(SUGGEST_APPROVAL_ATTRIBUTE));
                try {
                    PrivatePermission permission = null;
                    if (this.isValidAttribute(datumId) && this.isValidAttribute(principalId) && this.isValidAttribute(purpose) && this.isValidAttribute(policy) && approvalType != null) {
                        permission = new PrivatePermission(this.privateDatumMap.get(datumId), this.principalMap.get(principalId), purpose, policy, suggestApproval, approvalType, this);
                        advancedConfigMap.put(permission, configurationElement);
                        this.datumCategoryMap.get(datumId).addPermissions(permission);
                        if (this.principalCategoryMap.containsKey(principalId)) {
                            this.principalCategoryMap.get(principalId).addPermissions(permission);
                        }
                    }
                    if (permission == null) {
                        LOG.error("Failed to read permission, invalid or missing attribute");
                    }
                }
                catch (Exception e) {
                    LOG.error("Error while reading permission", (Throwable)e);
                }
            }
            ++n2;
        }
        this.advancedConfigMap = advancedConfigMap;
    }

    public Set<DatumCategory> getDatumCategory() {
        return this.datumCategorySet;
    }

    public Set<PrincipalCategory> getPrincipalCategory() {
        return this.princiaplCategorySet;
    }

    public boolean isAdvancedPreferencesSupported(PrivatePermission permission) {
        IConfigurationElement configElement = this.advancedConfigMap.get(permission);
        String advancedConfigurationDialog = configElement.getAttribute(CONFIGURATION_DIALOG_ATTRIBUTE);
        return !Strings.isNullOrEmpty((String)advancedConfigurationDialog);
    }

    public Optional<IConfigurationDialogFactory> getConfigurationDialog(PrivatePermission permission) {
        IConfigurationElement configElement = this.advancedConfigMap.get(permission);
        try {
            Object callback = configElement.createExecutableExtension(CONFIGURATION_DIALOG_ATTRIBUTE);
            if (callback instanceof IConfigurationDialogFactory) {
                IConfigurationDialogFactory factory = (IConfigurationDialogFactory)callback;
                return Optional.of((Object)factory);
            }
        }
        catch (CoreException e) {
            LOG.warn("Permission does not support configuration mechanism", (Throwable)e);
        }
        return Optional.fromNullable(null);
    }

    private ImageDescriptor getImageDescriptor(String pluginId, String icon, String defaultIcon) {
        ImageDescriptor imageDescriptor = icon == null ? AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.recommenders.privacy.rcp", (String)defaultIcon) : AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)icon);
        return imageDescriptor;
    }

    private ApprovalType toApprovalType(String type) {
        Object approvalType = type == null ? ApprovalType.INSTALL : (!ApprovalType.isValidType(type.toUpperCase()) ? null : ApprovalType.valueOf(type.toUpperCase()));
        return approvalType;
    }

    private boolean isValidAttribute(String attribute) {
        return !Strings.isNullOrEmpty((String)attribute);
    }
}

