/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.privacy.rcp.jobs;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.recommenders.internal.privacy.rcp.data.ApprovalType;
import org.eclipse.recommenders.internal.privacy.rcp.data.ExtensionReader;
import org.eclipse.recommenders.internal.privacy.rcp.data.ICategory;
import org.eclipse.recommenders.internal.privacy.rcp.data.PrincipalCategory;
import org.eclipse.recommenders.internal.privacy.rcp.data.PrivacySettingsSerciveHelper;
import org.eclipse.recommenders.internal.privacy.rcp.data.PrivatePermission;
import org.eclipse.recommenders.internal.privacy.rcp.dialogs.PermissionApprovalDialog;
import org.eclipse.recommenders.internal.privacy.rcp.l10n.Messages;
import org.eclipse.recommenders.internal.privacy.rcp.widgets.CompositeType;
import org.eclipse.recommenders.internal.privacy.rcp.widgets.PermissionWidget;
import org.eclipse.recommenders.internal.privacy.rcp.wizards.PermissionApprovalWizard;
import org.eclipse.recommenders.privacy.rcp.IPrivacySettingsService;
import org.eclipse.recommenders.privacy.rcp.PermissionState;
import org.eclipse.ui.progress.UIJob;
import org.osgi.service.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApprovalDialogJob
extends UIJob {
    private static final Logger LOG = LoggerFactory.getLogger(ApprovalDialogJob.class);
    private final IPrivacySettingsService service;
    private final ExtensionReader extensionReader;
    private final IEclipsePreferences preferences;

    @Inject
    public ApprovalDialogJob(@Preference IEclipsePreferences preferences, IPrivacySettingsService privacySettingsService, IEclipseContext eclipseContext) {
        super(Messages.JOB_APPROVAL_DIALOG);
        this.preferences = preferences;
        this.service = privacySettingsService;
        this.extensionReader = new ExtensionReader();
    }

    public boolean shouldRun() {
        return Iterables.tryFind(this.getDetectedPermission(), (Predicate)new ContainInstallPredicate()).isPresent();
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        PermissionWidget permissionWidget = new PermissionWidget(this.extensionReader.getDatumCategory(), this.extensionReader.getPrincipalCategory());
        permissionWidget.setCheckedPermission(this.loadPermissions(this.extensionReader.getPrincipalCategory()));
        permissionWidget.setShownPermission(this.getDetectedPermission());
        permissionWidget.setTopComposite(CompositeType.PRINCIPAL);
        if (!this.isActivated()) {
            PermissionApprovalWizard permissionWizard = new PermissionApprovalWizard(this.service, this.extensionReader.getDatumCategory(), this.extensionReader.getPrincipalCategory(), this.getDetectedPermission());
            WizardDialog wizardDialog = new WizardDialog(this.getDisplay().getActiveShell(), (IWizard)permissionWizard);
            wizardDialog.setHelpAvailable(false);
            wizardDialog.open();
            this.firstTimeActivation();
        } else {
            PermissionApprovalDialog approvalDialog = new PermissionApprovalDialog(this.getDisplay().getActiveShell(), this.service, this.extensionReader.getDatumCategory(), this.extensionReader.getPrincipalCategory(), this.getDetectedPermission());
            approvalDialog.open();
        }
        return Status.OK_STATUS;
    }

    private Set<PrivatePermission> getDetectedPermission() {
        HashSet<PrivatePermission> detectedPermissions = new HashSet<PrivatePermission>();
        for (PrincipalCategory principalCategory : this.extensionReader.getPrincipalCategory()) {
            for (PrivatePermission permission : principalCategory.getPermissions()) {
                PermissionState state = this.service.getState(principalCategory.getId(), permission.getDatumId());
                if (!PermissionState.UNKNOWN.equals((Object)state)) continue;
                detectedPermissions.add(permission);
            }
        }
        return detectedPermissions;
    }

    private Set<PrivatePermission> loadPermissions(Set<? extends ICategory> input) {
        return PrivacySettingsSerciveHelper.suggestApproved(this.service, input);
    }

    private void firstTimeActivation() {
        this.preferences.putBoolean("activated", true);
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            LOG.error(Messages.LOG_ERROR_SAVING_PREFERENCES, (Throwable)e);
        }
    }

    private boolean isActivated() {
        return this.preferences.getBoolean("activated", false);
    }

    private static final class ContainInstallPredicate
    implements Predicate<PrivatePermission> {
        private ContainInstallPredicate() {
        }

        public boolean apply(PrivatePermission permission) {
            return ApprovalType.INSTALL.equals((Object)permission.getApprovalType());
        }
    }
}

