/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.privacy.rcp.preferences;

import com.ibm.icu.text.MessageFormat;
import java.util.Set;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.recommenders.internal.privacy.rcp.data.DatumCategory;
import org.eclipse.recommenders.internal.privacy.rcp.data.ExtensionReader;
import org.eclipse.recommenders.internal.privacy.rcp.data.PrivacySettingsSerciveHelper;
import org.eclipse.recommenders.internal.privacy.rcp.l10n.Messages;
import org.eclipse.recommenders.internal.privacy.rcp.preferences.PreferencesHelper;
import org.eclipse.recommenders.internal.privacy.rcp.widgets.SingleDatumWidget;
import org.eclipse.recommenders.privacy.rcp.IAnonymousIdService;
import org.eclipse.recommenders.privacy.rcp.IPrivacySettingsService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class AnonymousIdPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String ANONYMOUS_ID_DATUM = "org.eclipse.recommenders.privacy.rcp.datums.anonymousId";
    private IAnonymousIdService anonymousIdService;
    private IPrivacySettingsService settingsService;
    private ExtensionReader extensionReader;
    private Set<DatumCategory> datumCategorySet;
    private SingleDatumWidget anonymousIdWidget;

    public void init(IWorkbench workbench) {
        this.setMessage(Messages.ANONYMOUS_ID_PREFPAGE_TITLE);
        BundleContext bundleContext = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        IEclipseContext eclipseContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        this.anonymousIdService = (IAnonymousIdService)eclipseContext.get(IAnonymousIdService.class);
        this.settingsService = (IPrivacySettingsService)eclipseContext.get(IPrivacySettingsService.class);
        this.extensionReader = new ExtensionReader();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.createDescription(composite, Messages.ANONYMOUS_ID_PREFPAGE_DESCRIPTION);
        this.createAnonymousIdLabel(composite);
        this.createPermissionWidget(composite);
        this.applyDialogFont(composite);
        return parent;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.anonymousIdWidget.setCheckedPermissions(PrivacySettingsSerciveHelper.loadApproved(this.settingsService, this.datumCategorySet));
            this.anonymousIdWidget.refresh();
        }
        super.setVisible(visible);
    }

    private void createPermissionWidget(Composite parent) {
        this.datumCategorySet = this.extensionReader.getDatumCategory();
        this.anonymousIdWidget = new SingleDatumWidget(this.datumCategorySet, ANONYMOUS_ID_DATUM);
        this.anonymousIdWidget.createContents(parent);
    }

    private void createDescription(Composite parent, String message) {
        Link link = new Link(parent, 64);
        GridDataFactory.fillDefaults().hint(300, -1).grab(true, false).applyTo((Control)link);
        String linkToPreferencePage = PreferencesHelper.createLinkLabelToPreferencePage("org.eclipse.recommenders.privacy.rcp.preferencesPages.privacy");
        link.setText(MessageFormat.format((String)Messages.ANONYMOUS_ID_PREFPAGE_DESCRIPTION, (Object[])new Object[]{linkToPreferencePage}));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)"org.eclipse.recommenders.privacy.rcp.preferencesPages.privacy", null, null);
                dialog.open();
            }
        });
    }

    private Control createAnonymousIdLabel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
        GridDataFactory.fillDefaults().grab(false, false).span(3, 1).applyTo((Control)composite);
        Label label = new Label(composite, 64);
        GridDataFactory.swtDefaults().applyTo((Control)label);
        label.setText(Messages.LABEL_ANONYMOUS_ID);
        final Text text = new Text(composite, 18444);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)text);
        text.setText(this.anonymousIdService.getAnonymousId().toString());
        Button uuidButton = new Button(composite, 8);
        GridDataFactory.swtDefaults().applyTo((Control)uuidButton);
        uuidButton.setText(Messages.BUTTON_GENERATE);
        uuidButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AnonymousIdPreferencePage.this.anonymousIdService.generateAnonymousId();
                text.setText(AnonymousIdPreferencePage.this.anonymousIdService.getAnonymousId().toString());
            }
        });
        return parent;
    }
}

