/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.privacy.rcp.preferences;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class PreferencesHelper {
    private static final String ID_ATTRIBUTE = "id";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String CATEGORY_ATTRIBUTE = "category";

    public static String createLinkLabelToPreferencePage(String preferencePageId) {
        String text = PreferencesHelper.getNameOfPreferencePage(preferencePageId);
        String categoryId = PreferencesHelper.getCategoryOfPreferencePage(preferencePageId);
        while (categoryId != null) {
            text = String.valueOf(PreferencesHelper.getNameOfPreferencePage(categoryId)) + " > " + text;
            categoryId = PreferencesHelper.getCategoryOfPreferencePage(categoryId);
        }
        return text == null ? "" : text;
    }

    private static String getNameOfPreferencePage(String preferencePageId) {
        return PreferencesHelper.getAttributeOfPreferencePage(preferencePageId, NAME_ATTRIBUTE);
    }

    private static String getCategoryOfPreferencePage(String preferencePageId) {
        return PreferencesHelper.getAttributeOfPreferencePage(preferencePageId, CATEGORY_ATTRIBUTE);
    }

    private static String getAttributeOfPreferencePage(String preferencePageId, String attribute) {
        IConfigurationElement[] elements;
        if (preferencePageId != null && (elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.preferencePages")) != null) {
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                String configId = e.getAttribute(ID_ATTRIBUTE);
                if (preferencePageId.equalsIgnoreCase(configId)) {
                    String value = e.getAttribute(attribute);
                    return value;
                }
                ++n2;
            }
        }
        return null;
    }
}

