/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.privacy.rcp.services;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.UUID;
import org.eclipse.recommenders.internal.privacy.rcp.l10n.Messages;
import org.eclipse.recommenders.privacy.rcp.IAnonymousIdService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnonymousIdService
implements IAnonymousIdService {
    private static final Logger LOG = LoggerFactory.getLogger(AnonymousIdService.class);
    private static final String USER_HOME = "user.home";
    private static final String DOT_ECLIPSE_DIRECTORY_NAME = ".eclipse";
    private static final String ANONYMOUS_ID_FILE_NAME = "anonymousId";
    private final File anonymousIdFile;
    private volatile UUID anonymousId;

    public AnonymousIdService() {
        this(AnonymousIdService.createAnonymousIdFile());
    }

    @VisibleForTesting
    AnonymousIdService(File anonymousIdFile) {
        this.anonymousIdFile = anonymousIdFile;
    }

    private static File createAnonymousIdFile() {
        File userHome = new File(System.getProperty(USER_HOME));
        File dotEclipseDir = new File(userHome, DOT_ECLIPSE_DIRECTORY_NAME);
        File bundleDir = new File(dotEclipseDir, "org.eclipse.recommenders.privacy.rcp");
        if (!bundleDir.exists()) {
            bundleDir.mkdirs();
        }
        return new File(bundleDir, ANONYMOUS_ID_FILE_NAME);
    }

    @Override
    public synchronized void generateAnonymousId() {
        this.anonymousId = this.generateFreshAnonymousId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID getAnonymousId() {
        UUID result = this.anonymousId;
        if (result == null) {
            AnonymousIdService anonymousIdService = this;
            synchronized (anonymousIdService) {
                result = this.anonymousId;
                if (result == null) {
                    result = this.anonymousId = this.readOrCreateAnonymousId();
                }
            }
        }
        return result;
    }

    private UUID generateFreshAnonymousId() {
        UUID freshAnonymousId;
        while ((freshAnonymousId = UUID.randomUUID()).equals(this.anonymousId)) {
        }
        try {
            Files.write((CharSequence)freshAnonymousId.toString(), (File)this.anonymousIdFile, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            LOG.error(MessageFormat.format((String)Messages.LOG_ERROR_ANONYMOUS_ID_FILE_WRITE, (Object[])new Object[]{this.anonymousIdFile}), (Throwable)e);
        }
        return freshAnonymousId;
    }

    private UUID readOrCreateAnonymousId() {
        if (this.anonymousIdFile.exists() && this.anonymousIdFile.canRead()) {
            try {
                return this.readAnonymousIdFromFile(this.anonymousIdFile);
            }
            catch (Exception e) {
                LOG.error(MessageFormat.format((String)Messages.LOG_ERROR_ANONYMOUS_ID_FILE_READ, (Object[])new Object[]{this.anonymousIdFile}), (Throwable)e);
                return this.generateFreshAnonymousId();
            }
        }
        return this.generateFreshAnonymousId();
    }

    private UUID readAnonymousIdFromFile(File file) throws IOException {
        String anonymousIdString = Files.readFirstLine((File)file, (Charset)Charsets.UTF_8);
        return UUID.fromString(new String(anonymousIdString));
    }
}

