/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.privacy.rcp.services;

import java.util.ArrayList;
import java.util.Arrays;
import javax.inject.Inject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.recommenders.internal.privacy.rcp.l10n.Messages;
import org.eclipse.recommenders.privacy.rcp.IPrivacySettingsService;
import org.eclipse.recommenders.privacy.rcp.PermissionState;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PrivacySettingsService
implements IPrivacySettingsService {
    private static final Logger LOG = LoggerFactory.getLogger(PrivacySettingsService.class);
    private static final String PREF_APPROVED = "+";
    private static final String PREF_DISAPPROVED = "-";
    private final IEclipsePreferences preferences;

    @Inject
    public PrivacySettingsService(@Preference IEclipsePreferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public void setState(String principalId, String datumId, PermissionState state) {
        this.store(principalId, datumId, state);
    }

    @Override
    public PermissionState getState(String principalId, String datumId) {
        Preferences root = this.preferences.node("approval");
        String state = root.node(datumId).get(principalId, "");
        if (PREF_APPROVED.equals(state)) {
            return PermissionState.APPROVED;
        }
        if (PREF_DISAPPROVED.equals(state)) {
            return PermissionState.DISAPPROVED;
        }
        return PermissionState.UNKNOWN;
    }

    @Override
    public void approve(String principalId, String datumId) {
        this.store(datumId, principalId, PermissionState.APPROVED);
    }

    @Override
    public void disapprove(String principalId, String datumId) {
        this.store(datumId, principalId, PermissionState.DISAPPROVED);
    }

    @Override
    public boolean isApproved(String principalId, String ... datumsIds) {
        String[] stringArray = datumsIds;
        int n = datumsIds.length;
        int n2 = 0;
        while (n2 < n) {
            String datumId = stringArray[n2];
            PermissionState state = this.getState(principalId, datumId);
            if (PermissionState.DISAPPROVED.equals((Object)state) || PermissionState.UNKNOWN.equals((Object)state)) {
                return false;
            }
            ++n2;
        }
        return datumsIds.length > 0;
    }

    @Override
    public boolean isNotYetDecided(String principalId, String ... datumsIds) {
        String[] stringArray = datumsIds;
        int n = datumsIds.length;
        int n2 = 0;
        while (n2 < n) {
            String datumId = stringArray[n2];
            PermissionState state = this.getState(principalId, datumId);
            if (PermissionState.UNKNOWN.equals((Object)state)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isAllApproved(String principalId) {
        String[] datums = this.getDatumsForPrincipal(principalId);
        return this.isApproved(principalId, datums);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isNeverApproved(String datumId) {
        Preferences root = this.preferences.node("approval");
        try {
            if (!root.nodeExists(datumId)) {
                return true;
            }
            Preferences node = root.node(datumId);
            String[] stringArray = node.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                String principalId = stringArray[n2];
                if (PREF_APPROVED.equals(node.get(principalId, ""))) {
                    return false;
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            LOG.error(Messages.LOG_ERROR_LOADING_PREFERENCES, (Throwable)e);
        }
        return true;
    }

    private String[] getDatumsForPrincipal(String principalId) {
        Preferences root = this.preferences.node("approval");
        ArrayList<String> datums = new ArrayList<String>();
        try {
            String[] stringArray = root.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String datumId = stringArray[n2];
                Preferences datum = root.node(datumId);
                if (Arrays.asList(datum.keys()).contains(principalId)) {
                    datums.add(datumId);
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            LOG.error(Messages.LOG_ERROR_LOADING_PREFERENCES, (Throwable)e);
        }
        return datums.toArray(new String[0]);
    }

    private void store(String principalId, String datumId, PermissionState state) {
        String value = PermissionState.APPROVED.equals((Object)state) ? PREF_APPROVED : PREF_DISAPPROVED;
        Preferences root = this.preferences.node("approval");
        root.node(datumId).put(principalId, value);
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            LOG.error(Messages.LOG_ERROR_SAVING_PREFERENCES, (Throwable)e);
        }
    }
}

