/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.privacy.rcp.wizards;

import com.ibm.icu.text.MessageFormat;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.recommenders.internal.privacy.rcp.data.ICategory;
import org.eclipse.recommenders.internal.privacy.rcp.data.PrivatePermission;
import org.eclipse.recommenders.internal.privacy.rcp.l10n.Messages;
import org.eclipse.recommenders.internal.privacy.rcp.preferences.PreferencesHelper;
import org.eclipse.recommenders.internal.privacy.rcp.preferences.PrivacyPreferencePage;
import org.eclipse.recommenders.internal.privacy.rcp.widgets.CompositeType;
import org.eclipse.recommenders.internal.privacy.rcp.widgets.PermissionWidget;
import org.eclipse.recommenders.internal.privacy.rcp.wizards.PermissionApprovalWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PermissionApprovalPage
extends WizardPage {
    private final PermissionWidget permissionWidget;
    private final Set<PrivatePermission> shownPermissions;

    public PermissionApprovalPage(PermissionApprovalWizard permissionApprovalWizard, Set<? extends ICategory> datumSet, Set<? extends ICategory> principalSet, Set<PrivatePermission> shownPermissions, Set<PrivatePermission> enabledPermissions) {
        super(Messages.WIZARD_PERMISSION_PAGE_TITLE);
        this.setTitle(Messages.WIZARD_PERMISSION_PAGE_TITLE);
        this.setDescription(Messages.WIZARD_PERMISSION_PAGE_DESCRIPTION);
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.recommenders.privacy.rcp", (String)"icons/wizban/logo.png"));
        this.permissionWidget = this.createPermissionWidget(datumSet, principalSet, shownPermissions, enabledPermissions);
        this.shownPermissions = shownPermissions;
    }

    private PermissionWidget createPermissionWidget(Set<? extends ICategory> datumSet, Set<? extends ICategory> principalSet, Set<PrivatePermission> shownPermissions, Set<PrivatePermission> checkedPermissions) {
        PermissionWidget permissionWidget = new PermissionWidget(datumSet, principalSet);
        permissionWidget.setShownPermission(shownPermissions);
        permissionWidget.setCheckedPermission(checkedPermissions);
        permissionWidget.setTopComposite(CompositeType.PRINCIPAL);
        return permissionWidget;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(container);
        this.createDescription(container, Messages.APPROVAL_DIALOG_MESSAGE);
        this.permissionWidget.createContents(container);
        this.createLinkToPreferencePage(container);
        Dialog.applyDialogFont((Control)container);
    }

    private void createDescription(Composite parent, String message) {
        Label label = new Label(parent, 64);
        label.setText(message);
        GridDataFactory.fillDefaults().hint(300, -1).applyTo((Control)label);
    }

    private void createLinkToPreferencePage(Composite container) {
        Link link = new Link(container, 64);
        String linkToPreferencePage = PreferencesHelper.createLinkLabelToPreferencePage("org.eclipse.recommenders.privacy.rcp.preferencesPages.privacy");
        link.setText(MessageFormat.format((String)Messages.PREF_LINK_MESSAGE, (Object[])new Object[]{linkToPreferencePage}));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)"org.eclipse.recommenders.privacy.rcp.preferencesPages.privacy", null, null);
                PrivacyPreferencePage preferencePage = (PrivacyPreferencePage)((Object)dialog.getSelectedPage());
                preferencePage.checkElements(PermissionApprovalPage.this.permissionWidget.getAllApprovedPermissions());
                PermissionApprovalPage.this.getWizard().performCancel();
                PermissionApprovalPage.this.getWizard().getContainer().getShell().close();
                dialog.open();
            }
        });
        this.setControl((Control)container);
    }

    public Set<PrivatePermission> getApprovedPermissions() {
        return this.permissionWidget.getApprovedPermissions(this.shownPermissions);
    }

    public Set<PrivatePermission> getDisapprovedPermissions() {
        return this.permissionWidget.getDisapprovedPermissions(this.shownPermissions);
    }
}

