/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.privacy.heartbeat.rcp.services;

import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.equinox.internal.p2.transport.ecf.RepositoryTransport;
import org.eclipse.recommenders.privacy.heartbeat.rcp.IHeartbeatService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatService
implements IHeartbeatService {
    private static final Logger LOG = LoggerFactory.getLogger(HeartbeatService.class);
    private static final String PATH_FORMATTER = "%s-%s";

    @Override
    public void sendHeartbeat(String uriPrefix, String bundleName, String bundleVersion, IProgressMonitor monitor, String query) {
        RepositoryTransport transport = new RepositoryTransport();
        URI uri = this.createURI(uriPrefix, query, bundleName, bundleVersion);
        try {
            transport.getLastModified(uri, monitor);
            LOG.info("Heartbeat successfuly sent to specified URI: <{}>", (Object)uri);
        }
        catch (AuthenticationFailedException e) {
            LOG.error("Authentication with specified URI failed", (Throwable)e);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (CoreException e) {
            LOG.error("Sending Heartbeat failed", (Throwable)e);
        }
    }

    private URI createURI(String uriPrefix, String query, String bundleName, String bundleVersion) {
        URI uri = null;
        try {
            String extension = String.format(PATH_FORMATTER, bundleName, bundleVersion);
            uri = URIUtil.append((URI)new URI(uriPrefix), (String)extension);
            uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), query, uri.getFragment());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        LOG.info("URI created: " + uri);
        return uri;
    }
}

