/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.privacy.rcp.data;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.recommenders.internal.privacy.rcp.data.ICategory;
import org.eclipse.recommenders.internal.privacy.rcp.data.PrivateDatum;
import org.eclipse.recommenders.internal.privacy.rcp.data.PrivatePermission;
import org.eclipse.swt.graphics.Image;

public class DatumCategory
implements ICategory {
    private final PrivateDatum datum;
    private final Set<PrivatePermission> permissionSet = new HashSet<PrivatePermission>();

    public DatumCategory(PrivateDatum datum) {
        this.datum = (PrivateDatum)Preconditions.checkNotNull((Object)datum);
    }

    public String getId() {
        return this.datum.getId();
    }

    public String getDescription() {
        return this.datum.getDescription();
    }

    public ImageDescriptor getIcon() {
        return this.datum.getIcon();
    }

    public String getName() {
        return this.datum.getName();
    }

    @Override
    public String getText() {
        return this.getName();
    }

    @Override
    public String getTooltip() {
        return this.getDescription();
    }

    @Override
    public Image getImageDescriptor() {
        return this.datum.getIcon().createImage();
    }

    @Override
    public Set<PrivatePermission> getPermissions() {
        return Collections.unmodifiableSet(this.permissionSet);
    }

    public void addPermissions(PrivatePermission ... permissions) {
        PrivatePermission[] privatePermissionArray = permissions;
        int n = permissions.length;
        int n2 = 0;
        while (n2 < n) {
            PrivatePermission permission = privatePermissionArray[n2];
            this.permissionSet.add(permission);
            ++n2;
        }
    }

    public String toString() {
        return this.datum.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DatumCategory other = (DatumCategory)obj;
        return this.datum.equals(other.datum);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.datum == null ? 0 : this.datum.hashCode());
        return result;
    }
}

